# -*- coding:utf-8 -*-
# 项目: WebService
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 2019/7/24
from optparse import OptionParser
from ZSI.wstools import logging
from ZSI.ServiceContainer import AsServer
from ZSI import dispatch
from SquareService_server import SquareService
from ZSI.twisted.wsgi import SOAPApplication, soapmethod
from ZSI.twisted.wsgi import WSGIApplication, _resourceToWSDL
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer
from ZSI.ServiceContainer import SOAPRequestHandler
from os import path
import re
import sys
import time


import urlparse, types
from ZSI.TCcompound import ComplexType, Struct
from ZSI import client
from ZSI.schema import GED, GTD
import ZSI

class getSquareRequest:
    def __init__(self, **kw):
        """Keyword parameters:
        x -- part x
        """
        self._x =  kw.get("x")
getSquareRequest.typecode = Struct(pname=("http://localhost:8066/SquareService","getSquare"), ofwhat=[ZSI.TCnumbers.FPdouble(pname="x", aname="_x", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getSquareRequest, encoded="http://localhost:8066/SquareService")


class getSquareResponse:
    def __init__(self, **kw):
        """Keyword parameters:
        return -- part return
        """
        self._return =  kw.get("return")
getSquareResponse.typecode = Struct(pname=("http://localhost:8066/SquareService","getSquareResponse"), ofwhat=[ZSI.TCnumbers.FPdouble(pname="return", aname="_return", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getSquareResponse, encoded="http://localhost:8066/SquareService")


class SOAPWsgiApplication(SOAPApplication, SquareService):
    _wsdl = "".join(open("%s/SquareService.wsdl" % path.dirname(__file__)).readlines())

    def __call__(self, req_env, start_response):
        if req_env['PATH_INFO'] == '/SquareService':
            return super(SOAPWsgiApplication, self).__call__(
                req_env, start_response)

    def _handle_GET(self, env, start_response):
        if env['QUERY_STRING'].lower() == 'wsdl':
            wsdl = self._wsdl
            proto = 'http'
            serviceUrl = '%s://%s:%d%s' % (proto,
                                           'localhost',
                                           8066,
                                           '/SquareService')
            soapAddress = '<soap:address location="%s"/>' % serviceUrl
            wsdlre = re.compile('\<soap:address[^\>]*>', re.IGNORECASE)
            wsdl = re.sub(wsdlre, soapAddress, wsdl)
            start_response("200 OK", [('Content-Type', 'text/xml; charset="utf-8"'),
                                      ('Content-Length', str(len(wsdl)))])
            return wsdl

    @soapmethod(getSquareRequest.typecode, getSquareResponse.typecode)
    def soap_getSquare(self, req, rsp):
        # Call the generated base class method to get appropriate
        # input/output data structures
        rsp._return = self.getSquare(req._x)
        return req, rsp
    
    

application = SOAPWsgiApplication()
