# -*- coding: utf-8 -*-
import hashlib
import random
import string
import math
import odoo
import re
import pytz
import datetime
import base64
from cStringIO import StringIO
from odoo.tools import config
from PIL import Image, ImageDraw, ImageFont, ImageFilter
import warnings
import werkzeug
from decimal import Decimal

G_PARAMS = {}


def today(timezone='Asia/Shanghai', str_format=None, **kwargs):
    '''
    :param timezone:
    :param str_format:
    :param kwargs: delay_days
    :return:
    '''
    import datetime
    import pytz

    day_delay = kwargs.get('delay_days', 0)
    tz = pytz.timezone(timezone)
    current = datetime.datetime.now(tz)
    if day_delay != 0:
        current = current + datetime.timedelta(days=day_delay)
    if not str_format:
        str_format = odoo.tools.DEFAULT_SERVER_DATE_FORMAT
    current_date = current.strftime(str_format)
    return current_date


def current_time(timezone='Asia/Shanghai', str_format=None):
    import datetime
    import pytz

    tz = pytz.timezone(timezone)
    current = datetime.datetime.now(tz)
    if not str_format:
        str_format = odoo.tools.DEFAULT_SERVER_TIME_FORMAT
    current_time_str = current.strftime(str_format)
    return current_time_str


def encode_md5(encode_str):
    '''
    生成字符串的md5
    :param encode_str:
    :return:
    '''
    if not encode_str:
        return encode_str
    m = hashlib.md5()
    m.update(encode_str)
    return m.hexdigest()


def is_prod():
    '''
    是否是生产环境
    :return:
    '''
    return config.get('environment', 'dev') == 'prod'


def get_min_max_date(key, domain):
    '''
    获取domain中的最小业务日期以及最大业务日期
    :param key:
    :param domain:
    :return:
    '''
    from dateutils import dateutils
    min_date = None
    max_date = None
    for domain_item in domain:
        if domain_item[0] == key:
            if domain_item[1] == '>' or domain_item[1] == '>=':
                date_wrap = dateutils.date_from_str(domain_item[2])
                if not min_date:
                    min_date = date_wrap
                if date_wrap < min_date:
                    min_date = date_wrap
            if domain_item[1] == '<' or domain_item[1] == '<=':
                date_warp = dateutils.date_from_str(domain_item[2])
                if not max_date:
                    max_date = date_warp
                if date_warp > max_date:
                    max_date = date_warp
    min_date = None if not min_date else dateutils.date_to_str(min_date)
    max_date = None if not max_date else dateutils.date_to_str(max_date)
    return min_date, max_date


def get_min_max_value(field_name, domain):
    '''
    获取domain中的最小和最大值
    :param field_name: 要比较的字段
    :param domain:
    :return:[min_value,max_value]
    '''
    max_value = None
    min_value = None
    for item in domain:
        if len(item) == 3 and item[0] == field_name:
            if item[1] in (u'<', u'<='):
                max_value = item[2]
            elif item[1] in (u'>', u'>='):
                min_value = item[2]
            elif item[1] == u'=':
                min_value = max_value = item[2]
    return [min_value, max_value]


def random_get(n):
    '''
    生成随机的n位字符串
    :param n:
    :return:
    '''
    source = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
              'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
              'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R',
              'S', 'T', 'U', 'V', 'W', 'Z', 'X', 'Y',
              'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o',
              'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k',
              'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm']
    return ''.join(random.sample(source, n))


def random_num_get(n):
    '''
    生成随机的n位数字字符串
    :param n:
    :return:
    '''
    source = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']
    return ''.join(random.sample(source, n))


def validate_id_number(id_number):
    """
    验证身份证号码是否合法
    :param id_number: 身份证号码
    :return: True/False
    """
    if id_number:
        is_match_id_num = re.findall(r'^([1-9]\d{5}[12]\d{3}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])\d{3}[0-9xX])$',
                                     id_number)
        if len(is_match_id_num) > 0 and len(id_number) == 18:
            return True
    return False


def validate_phone_number(phone_number):
    """
    验证手机号码是否合法
    :param phone_number: 手机号码
    :return: True/False
    """
    if phone_number:
        is_match_phone_num = re.findall(r'1[3456789]\d{9}',
                                        phone_number)
        if len(is_match_phone_num) > 0 and len(phone_number) == 11:
            return True
    return False


def validate_vehicle_number(number):
    """
    检查车牌号的合法性
    :param number:
    :return:
    """
    # 大部分标准车牌
    re_str_std = u'^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领]{1}[A-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1}$'
    # 新能源车牌
    re_str_elec = u'^([京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领][a-zA-Z](([DF](?![IO])[A-Z0-9][0-9]{4})|([0-9]{5}[DF])))$'
    if re.match(re_str_std, number) or re.match(re_str_elec, number):
        return True
    else:
        return False


# 统一社会信用代码中不使用I,O,Z,S,V
SOCIAL_CREDIT_CHECK_CODE_DICT = {
    '0': 0, '1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9,
    'A': 10, 'B': 11, 'C': 12, 'D': 13, 'E': 14, 'F': 15, 'G': 16, 'H': 17, 'J': 18, 'K': 19, 'L': 20, 'M': 21, 'N': 22,
    'P': 23, 'Q': 24,
    'R': 25, 'T': 26, 'U': 27, 'W': 28, 'X': 29, 'Y': 30}
# GB11714-1997全国组织机构代码编制规则中代码字符集
ORGANIZATION_CHECK_CODE_DICT = {
    '0': 0, '1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9,
    'A': 10, 'B': 11, 'C': 12, 'D': 13, 'E': 14, 'F': 15, 'G': 16, 'H': 17, 'I': 18, 'J': 19, 'K': 20, 'L': 21, 'M': 22,
    'N': 23, 'O': 24, 'P': 25, 'Q': 26,
    'R': 27, 'S': 28, 'T': 29, 'U': 30, 'V': 31, 'W': 32, 'X': 33, 'Y': 34, 'Z': 35}


def check_social_credit_code(code):
    '''
    校验统一社会信用代码的校验码
    计算校验码公式:
        C9 = 31-mod(sum(Ci*Wi)，31)，其中Ci为组织机构代码的第i位字符,Wi为第i位置的加权因子,C9为校验码
    '''
    # 第i位置上的加权因子
    weighting_factor = [1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28]
    # 本体代码
    ontology_code = code[0:17]
    # 校验码
    check_code = code[17]
    # 计算校验码
    tmp_check_code = gen_check_code(weighting_factor, ontology_code, 31, SOCIAL_CREDIT_CHECK_CODE_DICT)
    if tmp_check_code == check_code:
        return True
    else:
        return False


def check_organization_code(code):
    '''
    校验组织机构代码是否正确,该规则按照GB 11714编制
    统一社会信用代码的第9~17位为主体标识码(组织机构代码)，共九位字符
    计算校验码公式:
        C9 = 11-mod(sum(Ci*Wi)，11)，其中Ci为组织机构代码的第i位字符,Wi为第i位置的加权因子,C9为校验码
    @param  code: 统一社会信用代码
    '''
    # 第i位置上的加权因子
    weighting_factor = [3, 7, 9, 10, 5, 8, 4, 2]
    # 第9~17位为主体标识码(组织机构代码)
    organization_code = code[8:17]
    # 本体代码
    ontology_code = organization_code[0:8]
    # 校验码
    check_code = organization_code[8]
    #
    # 计算校验码
    tmp_check_code = gen_check_code(weighting_factor, ontology_code, 11, ORGANIZATION_CHECK_CODE_DICT)
    if tmp_check_code == check_code:
        return True
    else:
        return False


def check_email(email):
    """
    检测邮箱的合法性
    :param email:
    :return:
    """
    str = r'^[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+){0,4}@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+){0,4}$'
    if re.match(str, email):
        return True
    else:
        return False


def check_fax(fax):
    """
    检测传真的合法性
    :param fax:
    :return:
    """
    return True


def check_zip(zip):
    """
    检测邮编的合法性
    :param zip:
    :return:
    """
    str = r'^[0-9]{6}$'
    if re.match(str, zip):
        return True
    else:
        return False


def check_bank_card(card_num):
    """
    检查银行卡的合法性
    :param card_num:
    :return:
    """
    total = 0
    even = True
    if isinstance(card_num, int):
        card_num = str(card_num)
    check_num = card_num[-1]
    for item in card_num[-2::-1]:
        item = int(item)
        if even:
            item <<= 1
        if item > 9:
            item -= 9
        total += item
        even = not even
    return int(check_num) is (10 - (total % 10)) % 10


def gen_check_code(weighting_factor, ontology_code, modulus, check_code_dict):
    '''
    @param weighting_factor: 加权因子
    @param ontology_code:本体代码
    @param modulus:  模数
    @param check_code_dict: 字符字典
    '''
    total = 0
    for i in range(len(ontology_code)):
        if ontology_code[i].isdigit():
            total += int(ontology_code[i]) * weighting_factor[i]
        else:
            total += check_code_dict[ontology_code[i]] * weighting_factor[i]
    diff = modulus - total % modulus
    return check_code_dict.keys()[check_code_dict.values()[diff]]


letters_without_i = 'abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ'


def random_color():  # 产生随机颜色
    return (random.randint(64, 255), random.randint(64, 255), random.randint(64, 255))


def random_chars(n):  # 产生随机字母加数字
    return random.sample(string.digits + letters_without_i, n)


def random_num(n):  # 产生随机数字
    return random.sample(string.digits, n)


def random_color2():
    return (random.randint(30, 120), random.randint(30, 120), random.randint(30, 120))


def draw_lines(draw, num, width, height):
    # 划线
    for num in range(num):
        x1 = random.randint(0, width / 2)
        x2 = random.randint(0, width)
        y2 = random.randint(height / 2, height)
        y1 = random.randint(0, height / 2)
        draw.line(((x1, y1), (x2, y2)), fill='black', width=1)


def create_points(draw, point_chance, width, height):
    # 绘制干扰点
    chance = min(100, max(0, int(point_chance)))  # 大小限制在[0, 100]
    for w in range(width):
        for h in range(height):
            tmp = random.randint(0, 100)
            if tmp > 100 - chance:
                draw.point((w, h), fill=(0, 0, 0))


def create_image_code(width=240, height=60):
    image = Image.new('RGB', (width, height), (255, 255, 255))  # 白色画布
    import os
    abs_path = os.path.abspath('.')
    font_path = os.path.join(abs_path, 'base/app_base/jd_base/static/src/font/Arial.ttf')
    font = ImageFont.truetype(font_path, 36)
    draw = ImageDraw.Draw(image)  # 绘画对象
    random_num = random_chars(4)

    for i in range(4):
        draw.text((60 * i + 10, 10), random_num[i], font=font, fill=random_color2())  # 文本绘画

    draw_lines(draw, 3, width, height)
    create_points(draw, 10, width, height)

    image = image.filter(ImageFilter.GaussianBlur(radius=0.6))
    return random_num, image


def image_to_base64(image):
    output_buffer = StringIO()
    image.save(output_buffer, format='JPEG')
    binary_data = output_buffer.getvalue()
    base64_data = base64.b64encode(binary_data)
    return base64_data


def to_format_rmb(value, capital=True, prefix=False, classical=None):
    '''
    人民币数字转大写。
    参数:
    capital:    True   大写汉字金额
                False  一般汉字金额
    classical:  True   元
                False  圆
    prefix:     True   以'人民币'开头
                False, 无开头
    '''
    # 默认大写金额用圆，一般汉字金额用元
    if classical is None:
        classical = True if capital else False

    # 汉字金额前缀
    if prefix is True:
        prefix = '人民币'
    else:
        prefix = ''

    # 汉字金额字符定义
    dunit = ('角', '分')
    if capital:
        num = ('零', '壹', '贰', '叁', '肆', '伍', '陆', '柒', '捌', '玖')
        iunit = [None, '拾', '佰', '仟', '万', '拾', '佰', '仟', '亿', '拾', '佰', '仟', '万', '拾', '佰', '仟']
    else:
        num = ('〇', '一', '二', '三', '四', '五', '六', '七', '八', '九')
        iunit = [None, '十', '百', '千', '万', '十', '百', '千', '亿', '十', '百', '千', '万', '十', '百', '千']
    if classical:
        iunit[0] = '元' if classical else '圆'
    # 转换为Decimal，并截断多余小数
    if not isinstance(value, Decimal):
        value = Decimal(value).quantize(Decimal('0.01'))

    # 处理负数
    if value < 0:
        prefix += '负'  # 输出前缀，加负
        value = - value  # 取正数部分，无须过多考虑正负数舍入

    # 转化为字符串
    s = str(value)
    if len(s) > 19:
        raise ValueError('金额过大！')
    istr, dstr = s.split('.')  # 小数部分和整数部分分别处理
    istr = istr[::-1]  # 翻转整数部分字符串
    so = []  # 用于记录转换结果

    # 零
    if value == 0:
        return prefix + num[0] + iunit[0]
    haszero = False  # 用于标记零的使用
    if dstr == '00':
        haszero = True  # 如果无小数部分，则标记加过零，避免出现“圆零整”

    # 处理小数部分
    # 分
    if dstr[1] != '0':
        so.append(dunit[1])
        so.append(num[int(dstr[1])])
    else:
        so.append('整')  # 无分，则加“整”
    # 角
    if dstr[0] != '0':
        so.append(dunit[0])
        so.append(num[int(dstr[0])])
    elif dstr[1] != '0':
        so.append(num[0])  # 无角有分，添加“零”
        haszero = True  # 标记加过零了

    # 无整数部分
    if istr == '0':
        if haszero:  # 既然无整数部分，那么去掉角位置上的零
            so.pop()
        so.append(prefix)  # 加前缀
        so.reverse()  # 翻转
        return ''.join(so)

    # 处理整数部分
    for i, n in enumerate(istr):
        n = int(n)
        if i % 4 == 0:  # 在圆、万、亿等位上，即使是零，也必须有单位
            if i == 8 and so[-1] == iunit[4]:  # 亿和万之间全部为零的情况
                so.pop()  # 去掉万
            so.append(iunit[i])
            if n == 0:  # 处理这些位上为零的情况
                if not haszero:  # 如果以前没有加过零
                    so.insert(-1, num[0])  # 则在单位后面加零
                    haszero = True  # 标记加过零了
            else:  # 处理不为零的情况
                so.append(num[n])
                haszero = False  # 重新开始标记加零的情况
        else:  # 在其他位置上
            if n != 0:  # 不为零的情况
                so.append(iunit[i])
                so.append(num[n])
                haszero = False  # 重新开始标记加零的情况
            else:  # 处理为零的情况
                if not haszero:  # 如果以前没有加过零
                    so.append(num[0])
                    haszero = True

    # 最终结果
    so.append(prefix)
    so.reverse()
    return ''.join(so)


def gateway_result_format(success=True, msg='请求成功', data={}):
    '''
    返回网关的统一样式
    :param success: 是否请求成功
    :param msg: 返回网关的信息
    :param data: 返回网关的数据
    :return: 
    '''
    return {
        'success': success,
        'msg': msg,
        'data': data
    }


def compare_version(a, b):
    la = a.split('.')
    lb = b.split('.')
    f = 0
    if len(la) > len(lb):
        f = len(la)
    else:
        f = len(lb)
    for i in range(f):
        try:
            if int(la[i]) > int(lb[i]):
                # print(a + '>' + b)
                return True
            elif int(la[i]) == int(lb[i]):
                continue
            else:
                # print(a + '<' + b)
                return False
        except IndexError as e:
            if len(la) > len(lb):
                # print(a + '>' + b)
                return True
            else:
                # print(a + '<' + b)
                return False
    # print(a + '=' + b)
    return False


def str_to_bool(str):
    """
    str转bool
    :param str:
    :return:
    """
    return True if str.lower() == 'true' else False


def encrypt_param(param, rule=(1, 3, 5, 8, 10), dynamic=False):
    '''
    传入参数，生成该参数的base64密文对象
    :param param: url参数
    :param rule: 插入位置规则
    :param dynamic: 插入的url特定位置的盐是否动态生成
    :return: {'p': base64密文}
    '''
    url_base64_str = base64.urlsafe_b64encode(werkzeug.url_encode(param))
    # 混淆
    if dynamic:
        random_str = random_get(5)
    else:
        random_str = 'j1d8g'
    base64_list = list(url_base64_str)
    for i in range(0, len(rule)):
        base64_list.insert(rule[i], random_str[i])
    encrypt_url_base64 = ''.join(base64_list)

    return werkzeug.url_encode({'p': encrypt_url_base64})


def decrypt_param(encrypt_base64, is_raw_url=False, rule=(1, 3, 5, 8, 10)):
    '''
    传入base64密码字符串，返回字典类型的参数
    :param encrypt_base64: 密文base64
    :param rule: 混淆规则
    :return: dict形式的参数
    '''

    if not encrypt_base64:
        return None
    if is_raw_url:
        encrypt_base64 = werkzeug.url_decode(encrypt_base64)
    # url解码(带盐的base64密文串[url编码] -> 带盐的base64密文串[未url编码])
    encrypt_base64 = werkzeug.url_unquote(encrypt_base64)
    # 逆序删减: 获取原base64字符串
    rule = list(rule)
    rule.reverse()
    encrypt_url_list = list(encrypt_base64)
    for i in range(0, len(rule)):
        del encrypt_url_list[rule[i]]

    # unicode -> bytes
    base64_param = str(''.join(encrypt_url_list))
    # base64解析回url字符串
    # url字符串获取参数
    param = werkzeug.url_decode(base64.urlsafe_b64decode(base64_param))

    return param


def change_image_with_time_pass(param_obj, values):
    values['random_number'] = str(int(math.ceil(random.random() * 100000)))
    values['disable_footer'] = (param_obj.get_param('login_form_disable_footer') == "True")
    values['disable_database_manager'] = (
            param_obj.get_param('login_form_disable_database_manager') == "True")
    values['disable_database_select'] = (
            param_obj.get_param('login_form_disable_database_select') == "True")
    change_background = param_obj.get_param('login_form_change_background_by_hour', None) or False
    if change_background:
        config_login_timezone = param_obj.get_param('login_form_change_background_timezone')
        tz = config_login_timezone and pytz.timezone(config_login_timezone) or pytz.utc
        current_hour = datetime.datetime.now(tz=tz).hour or 10

        if (0 <= current_hour < 3) or (18 <= current_hour < 24):  # Night
            values['background_src'] = param_obj.get_param('login_form_background_night') or ''
        elif 3 <= current_hour < 7:  # Dawn
            values['background_src'] = param_obj.get_param('login_form_background_dawn') or ''
        elif 7 <= current_hour < 16:  # Day
            values['background_src'] = param_obj.get_param('login_form_background_day') or ''
        else:  # Dusk
            values['background_src'] = param_obj.get_param('login_form_background_dusk') or ''
    else:
        values['background_src'] = param_obj.get_param('login_form_background_default') or ''
    return values
