# -*- encoding: utf-8 -*-
# 项目：JDG-
# 模块名称：
# 描述：
# Copyright 2018 JDG <www.yunside.com>
# Created by wxh (xianhuo.weng@yunside.com) at  2018/9/13 - 下午3:15
import datetime
import logging
from odoo.tools import config
from odoorpc import ODOO
from odoorpc import rpc, error, tools
from odoorpc.env import Environment

import urllib2
from odoo.http import request
import simplejson
from odoo import exceptions

_logger = logging.getLogger(__name__)


class RequestIntercept(urllib2.BaseHandler):
    def __init__(self, headers):
        if type(headers) != dict:
            raise exceptions.ValidationError(u'header类型应该为dict')
        self.headers = headers

    def http_request(self, req):
        for key, value in self.headers.items():
            req.add_header(key, value)
        return req


class TrustRPC(ODOO):

    def __init__(self, data_node_id, db_name, protocol='jsonrpc',
                 timeout=12000, version=None, opener=None, expire=10000, env=None):

        if not isinstance(data_node_id, int):
            raise error.RPCError("数据节点id是整型")
        self.data_node_id = data_node_id
        self.expire = expire
        self._env = env
        self._db_name = db_name

        # 初始化
        self._init()

        try:
            super(TrustRPC, self).__init__(host=self._host, port=self._port, protocol=protocol, timeout=timeout,
                                           version=version,
                                           opener=opener)
        except Exception as e:
            _logger.error(
                u'trust rpc登录异常：' + str(e.message) + '。\n异常类型：' + e.__class__.__name__ + '。异常信息：' + str(e.__str__()))
            raise exceptions.AccessError(u'访问数据节点【%s】失败，请检测服务器是否可用' % data_node_id)

        self.trust_login()

    def _init(self):

        # 获得对应的host 和 port 和 db
        env = self._env if self._env else request.env
        data_node_record = env['jd.data.node'].sudo().browse(self.data_node_id)
        self._host = data_node_record.node_url
        self._port = data_node_record.port
        # 若未传入db_name则默认使用数据节点使用的db_name
        if not self._db_name:
            self._db_name = data_node_record.db

    def trust_login(self):
        # 登录请求
        try:
            data = self.json(
                '/web/session/authenticate',
                {'db': self._db_name, 'login': '', 'password': ''})
            uid = data['result']['uid']
            if uid:
                context = data['result']['user_context']
                self._env = Environment(self, self._db_name, uid, context=context)
                self._login = ' '
                self._password = ' '
                # 找到系统对应的id
            else:
                raise error.RPCError("Wrong login ID or password")
        except Exception as e:
            if str(e) == 'Expected singleton: res.users[]':
                _logger.error(str(e))
                raise exceptions.AccessError(u'访问数据节点%s失败，请检查通信配置是否正确' % self.data_node_id)
            _logger.error(
                u'trust rpc初始化异常：' + str(e.message) + '。\n异常类型：' + e.__class__.__name__ + '。异常信息：' + str(e.__str__()))
            raise exceptions.AccessError(u'访问数据节点%s失败，请检测服务器是否可用' % self.data_node_id)
        uid = data['result']['uid']
        if uid:
            context = data['result']['user_context']
            self._env = Environment(self, self._db_name, uid, context=context)
            self._login = ' '
            self._password = ' '
            # 找到系统对应的id
        else:
            raise error.RPCError("Wrong login ID or password")


def get_trust_rpc(data_node_id, db_name=None, protocol='jsonrpc',
                  timeout=30000, version=None, opener=None, expire=10000, env=None):
    if opener:
        return TrustRPC(data_node_id, db_name, protocol=protocol, timeout=timeout, version=version, opener=opener,
                        expire=expire, env=env)
    else:
        env = env if env else request.env

        trust_rpc_request_tokens = env['jd.trust.rpc.setting'].get_trust_rpc_request()
        if not trust_rpc_request_tokens:
            raise exceptions.MissingError(u'配置文件缺失trust_rpc_request_tokens配置项，无法发起TRUST RPC请求')

        data_node_record = env['jd.data.node'].sudo().browse(data_node_id)

        try:
            request_ip = data_node_record.node_url
        except exceptions.MissingError:
            raise exceptions.MissingError(u'请检查是否存在数据节点【%s】' % data_node_id)

        # 检查是否拥有对应数据节点的访问权
        is_allow_request = False
        trust_rpc_request_token = ''
        for request_token_config_item in trust_rpc_request_tokens.split(';'):
            if not request_token_config_item:
                continue
            token_info = request_token_config_item.split(',')

            # 消除前后空格
            allow_request_ip = token_info[0].strip()
            allow_data_node_id = token_info[1].strip()
            trust_rpc_request_token = token_info[2].strip()

            if allow_request_ip == request_ip and data_node_id == int(allow_data_node_id) and trust_rpc_request_token:
                is_allow_request = True
                break

        if not is_allow_request:
            raise exceptions.ValidationError(u'不允许访问数据节点 %s' % str(data_node_id))

        # 获取当前节点的id
        current_data_node_id = env['ir.config_parameter'].sudo().get_param('jadedragon.microapp.data.node.id')
        request_intercept = RequestIntercept({'trust_rpc_request_token': trust_rpc_request_token,
                                              'request_data_node_id': current_data_node_id})
        opener = urllib2.build_opener(request_intercept)
        return TrustRPC(data_node_id, db_name, protocol=protocol, timeout=timeout, version=version, opener=opener,
                        expire=expire, env=env)
