# -*- coding: utf-8 -*-
import os
import random
import logging

from jinja2 import Environment, FileSystemLoader

import odoo

_logger = logging.getLogger(__name__)


def static(url, module=None):
    '''
    给静态文件加上版本号，避免升级缓存不更新的问题。
    '''

    if url.find("?") > 0:
        url = url + "&ver=" + str(random.randint(12, 20000000))
    else:
        url = url + "?ver=" + str(random.randint(12, 20000000))
    return url


class TemplateTools(object):
    '''
    模板工具类
    '''
    _environment = None

    def __init__(self, controller=None, path="/templates"):
        loader = None
        if controller and path:
            base_dic = os.path.dirname(os.path.dirname(controller))
            _logger.debug('template base file:' + base_dic)
            loader = FileSystemLoader(searchpath=base_dic + path)
        else:
            loader = FileSystemLoader(searchpath=odoo.modules.module.ad_paths)
        self._environment = Environment(loader=loader)
        self._environment.globals['static'] = static
        self._environment.globals['len'] = len

    def render(self, template, *args, **kwargs):
        template = self._environment.get_template(template)
        return template.render(*args, **kwargs)
