# -*- coding: utf-8 -*-
import logging

from odoo import fields as odoo_fields
from odoo import api, fields, models
import logging

from core.middleware.trust_rpc import get_trust_rpc
import simplejson
from odoo.tools import config
import re
from odoo.tools.safe_eval import safe_eval
from odoo.addons.base.ir.ir_model import make_compute
from odoo.fields import Field, Default, resolve_mro
from odoo.tools import float_precision, float_repr, float_round, frozendict, \
                       html_sanitize, human_size, pg_varchar, ustr, OrderedSet
from collections import OrderedDict, defaultdict
from functools import partial
from odoo.addons.base.ir.ir_model import IrModelFields
from core.middleware.dateutils import dateutils
_logger = logging.getLogger(__name__)


class MultiSelection(Field):

    type = 'multi_selection'
    _slots = {
        'selection': None,              # [(value, string), ...], function or method name
    }

    def __init__(self, selection=Default, string=Default, **kwargs):
        super(MultiSelection, self).__init__(selection=selection, string=string, **kwargs)

    @property
    def column_type(self):
        if (self.selection and
                isinstance(self.selection, list) and
                isinstance(self.selection[0][0], int)):
            return ('int4', 'integer')
        else:
            return ('varchar', pg_varchar())

    def _setup_regular_base(self, model):
        super(MultiSelection, self)._setup_regular_base(model)
        # assert self.selection is not None, "Field %s without selection" % self

    def _setup_related_full(self, model):
        super(MultiSelection, self)._setup_related_full(model)
        # selection must be computed on related field
        field = self.related_field
        self.selection = lambda model: field._description_selection(model.env)

    def _setup_attrs(self, model, name):
        super(MultiSelection, self)._setup_attrs(model, name)
        # determine selection (applying 'selection_add' extensions)
        for field in reversed(resolve_mro(model, name, self._can_setup_from)):
            # We cannot use field.selection or field.selection_add here
            # because those attributes are overridden by ``_setup_attrs``.
            if 'selection' in field.args:
                self.selection = field.args['selection']
            if 'selection_add' in field.args:
                # use an OrderedDict to update existing values
                selection_add = field.args['selection_add']
                self.selection = OrderedDict(self.selection + selection_add).items()

    def _description_selection(self, env):
        """ return the selection list (pairs (value, label)); labels are
            translated according to context language
        """
        selection = self.selection
        if isinstance(selection, basestring):
            return getattr(env[self.model_name], selection)()
        if callable(selection):
            return selection(env[self.model_name])

        # translate selection labels
        if env.lang:
            name = "%s,%s" % (self.model_name, self.name)
            translate = partial(
                env['ir.translation']._get_source, name, 'selection', env.lang)
            return [(value, translate(label) if label else label) for value, label in selection]
        else:
            return selection

    def get_values(self, env):
        """ return a list of the possible values """
        selection = self.selection
        if isinstance(selection, basestring):
            selection = getattr(env[self.model_name], selection)()
        elif callable(selection):
            selection = selection(env[self.model_name])
        # 可以返回一系列的组合。 [('first', '\xe7\xac\xac\xe4\xb8\x80'), ('second', '\xe7\xac\xac\xe4\xba\x8c')]
        # 可返回 first, second, first,second
        # TODO 返回排列组合后的结果。。
        return [value for value, _ in selection]

    def convert_to_cache(self, value, record, validate=True):
        if not validate:
            return value or False
        if value in self.get_values(record.env):
            return value
        elif not value:
            return False
        # raise ValueError("Wrong value for %s: %r" % (self, value))

    def convert_to_export(self, value, record):
        if not isinstance(self.selection, list):
            # FIXME: this reproduces an existing buggy behavior!
            return value if value else ''
        for item in self._description_selection(record.env):
            if item[0] == value:
                return item[1]
        return False

    def convert_to_column(self, value, record):
        """ Convert ``value`` from the ``write`` format to the SQL format. """
        if value is None or value is False:
            return None
        if isinstance(value, unicode):
            return value.encode('utf8')
        return str(value)



class AliOssImage(odoo_fields.Char):
    '''
    阿里OSS字段,需要配合ws_base模块使用
    '''
    type = 'alioss_image'


class Many2oneChar(odoo_fields.Many2one):
    '''
    字符串作为id的Many2one关联，比如eas的FID
    '''

    @property
    def column_type(self):
        return ('varchar', "VARCHAR(80)")


def make_function(text):
    # TODO 需要限制使用哪些函数
    func = None
    try:
        func = lambda self: eval(text)
    except Exception as e:
        _logger.error(e)
        _logger.error('default func error, please check current default value %s' % text)
    return func

@api.model
def _instanciate(self, field_data, partial):
    """ Return a field instance corresponding to parameters ``field_data``. """
    attrs = {
        'manual': True,
        'string': field_data['field_description'],
        'help': field_data['help'],
        'index': bool(field_data['index']),
        'copy': bool(field_data['copy']),
        'related': field_data['related'],
        'required': bool(field_data['required']),
        'readonly': bool(field_data['readonly']),
        'store': bool(field_data['store']),
    }
    if 'default' in field_data.keys() and field_data['default']:
        if str(field_data['default']).startswith('\"'):
            if field_data['default'] == '"last_month_first_day"':
                attrs.update({
                    'default': dateutils.get_str_last_month_first_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"last_month_last_day"':
                attrs.update({
                    'default': dateutils.get_str_last_month_last_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"last_week_first_day"':
                attrs.update({
                    'default': dateutils.get_str_last_week_first_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"last_week_last_day"':
                attrs.update({
                    'default': dateutils.get_str_last_week_last_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"this_week_first_day"':
                attrs.update({
                    'default': dateutils.get_str_this_week_first_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"this_week_last_day"':
                attrs.update({
                    'default': dateutils.get_str_this_week_last_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif str(field_data['default']) == '"this_month_first_day"':
                attrs.update({
                    'default': dateutils.get_str_cur_month_first_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"this_month_last_day"':
                attrs.update({
                    'default': dateutils.get_str_cur_month_last_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif str(field_data['default']) == '"next_month_first_day"':
                attrs.update({
                    'default': dateutils.get_str_next_month_first_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"next_month_last_day"':
                attrs.update({
                    'default': dateutils.get_str_next_month_last_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            elif field_data['default'] == '"this_year_first_day"':
                attrs.update({
                    'default': dateutils.get_str_this_year_first_day(fields.Date.context_today(self.with_context({'tz': 'UTC'})))
                })
            else:
                attrs.update({
                    'default': field_data['default']
                })
        else:
            attrs.update({
                'default': make_function(field_data['default'])
            })
    # FIXME: ignore field_data['serialization_field_id']
    if field_data['ttype'] in ('char', 'text', 'html'):
        attrs['translate'] = bool(field_data['translate'])
        attrs['size'] = field_data['size'] or None
    elif field_data['ttype'] in ('selection', 'reference', 'multi_selection'):
        attrs['selection'] = safe_eval(field_data['selection'])
    elif field_data['ttype'] == 'many2one':
        if partial and field_data['relation'] not in self.env:
            return
        attrs['comodel_name'] = field_data['relation']
        attrs['ondelete'] = field_data['on_delete']
        attrs['domain'] = safe_eval(field_data['domain'] or '[]')
    elif field_data['ttype'] == 'one2many':
        if partial and not (
                field_data['relation'] in self.env and (
                field_data['relation_field'] in self.env[field_data['relation']]._fields or
                field_data['relation_field'] in self.pool.get_manual_fields(self._cr, field_data['relation'])
        )):
            return
        attrs['comodel_name'] = field_data['relation']
        attrs['inverse_name'] = field_data['relation_field']
        attrs['domain'] = safe_eval(field_data['domain'] or '[]')
    elif field_data['ttype'] == 'many2many':
        if partial and field_data['relation'] not in self.env:
            return
        attrs['comodel_name'] = field_data['relation']
        rel, col1, col2 = self._custom_many2many_names(field_data['model'], field_data['relation'])
        attrs['relation'] = field_data['relation_table'] or rel
        attrs['column1'] = field_data['column1'] or col1
        attrs['column2'] = field_data['column2'] or col2
        attrs['domain'] = safe_eval(field_data['domain'] or '[]')
    # add compute function if given
    if field_data['compute']:
        attrs['compute'] = make_compute(field_data['compute'], field_data['depends'])
    if field_data.get('sparse'):
        attrs['sparse'] = field_data['sparse']

    return fields.Field.by_type[field_data['ttype']](**attrs)


def patch_fields():

    IrModelFields._instanciate = _instanciate