# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

"""

WSGI stack, common code.

"""

import httplib
import urllib
import xmlrpclib
import StringIO

import errno
import logging
import platform
import socket
import sys
import threading
import traceback

import werkzeug.serving
import werkzeug.contrib.fixers

import odoo
import odoo.tools.config as config
from odoo.service import wsgi_server
from odoo.service.wsgi_server import wsgi_xmlrpc
_logger = logging.getLogger(__name__)

# WSGI handlers registered through the register_wsgi_handler() function below.
module_handlers = []


def application_unproxied(environ, start_response):
    """ WSGI entry point."""
    # cleanup db/uid trackers - they're set at HTTP dispatch in
    # web.session.OpenERPSession.send() and at RPC dispatch in
    # odoo.service.web_services.objects_proxy.dispatch().
    # /!\ The cleanup cannot be done at the end of this `application`
    # method because werkzeug still produces relevant logging afterwards 
    if hasattr(threading.current_thread(), 'uid'):
        del threading.current_thread().uid
    if hasattr(threading.current_thread(), 'dbname'):
        del threading.current_thread().dbname
    if hasattr(threading.current_thread(), 'url'):
        del threading.current_thread().url

    # Try all handlers until one returns some result (i.e. not None).
    module_handlers.append(odoo.http.root)
    module_handlers.append(wsgi_xmlrpc)
    with odoo.api.Environment.manage():
        # Try all handlers until one returns some result (i.e. not None).
        for handler in module_handlers:
            result = handler(environ, start_response)
            if result is None:
                continue
            return result

    # We never returned from the loop.
    response = 'No handler found.\n'
    start_response('404 Not Found', [('Content-Type', 'text/plain'), ('Content-Length', str(len(response)))])
    return [response]


def patch_wsgi_server():
    wsgi_server.application_unproxied = application_unproxied
