# -*- coding:utf-8 -*-
# 项目: WebService
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 2019/7/18
from spyne import Application, ServiceBase, rpc
from spyne import Integer, Unicode, Array, ComplexModel, Iterable, String
from spyne import Mandatory as M
from spyne.protocol.soap import Soap11
from spyne.server.wsgi import WsgiApplication
from odoo.service import db
from odoo.modules.registry import RegistryManager
from odoo import SUPERUSER_ID
import odoo.tools.config as config
import json
import requests


def get_env():
    if not config['db_name']:
        raise Exception(u'未找到数据库配置项')
    db_name = config['db_name']
    registry = RegistryManager.get(db_name)
    cr = registry.cursor()
    from odoo import api
    env = api.Environment(cr, SUPERUSER_ID, {})
    return env


class SOAPWsgiApplication(WsgiApplication):

    def __call__(self, req_env, start_response, wsgi_url=None):
        """Only match URL requests starting with '/soap/'."""
        if req_env['PATH_INFO'].startswith('/soap/'):
            return super(SOAPWsgiApplication, self).__call__(
                req_env, start_response, wsgi_url)


class GatewayResponse(ComplexModel):
    Msg = String
    ErrorCode = String
    StatusCode = Integer

    def __init__(self, status_code, error_code, msg):
        self.StatusCode = status_code
        self.ErrorCode = error_code
        self.Msg = msg


class JdgService(ServiceBase):

    # 所有的请求必须经过网关，不允许直接访问后端系统
    __namespace__ = 'abstract'

    # 注册服务
    @rpc(M(String),  M(String), _returns=GatewayResponse)
    def call_method(self, MsgHeader, InputCollection):
        """
        :param MsgHeader:
        :param InputCollection:
        {
            'app_key': APP_KEY,
            'sign': Sign,
            'api': 'out.esb.call',
            'method': 'esb_call',
            'args': {
                'login': 'admin',
                'password': '1',
                'operation': 'hd.bd.esb.gateway.customer,enable_customer',
                'data': {
                    'id': 1,
                }
            }
        }
        :return:
        """
        InputCollection = json.loads(InputCollection)
        if 'app_key' not in InputCollection:
            return GatewayResponse(500, u'', u'未传入app_key参数，请检查')
        if 'sign' not in InputCollection:
            return GatewayResponse(500, u'', u'未传入sign参数，请检查')
        if 'api' not in InputCollection:
            return GatewayResponse(500, u'', u'未传入api参数，请检查')
        if 'api' in InputCollection and InputCollection['api'] != 'out.system.esb':
            return GatewayResponse(500, u'', u'api参数的值只允许为out.system.esb，请检查')
        if 'method' not in InputCollection:
            return GatewayResponse(500, u'', u'未传入method参数，请检查')
        if 'method' in InputCollection and InputCollection['method'] != 'esb_call':
            return GatewayResponse(500, u'', u'method参数的值只允许为esb_call，请检查')
        InputCollection.update({
            'args': json.dumps(InputCollection['args'])
        })
        if not config['xmlrpc_port']:
            raise Exception(u'未配置端口项')
        port = config['xmlrpc_port']
        Url = 'http://localhost:%s/api/gateway' % port
        try:
            resp = requests.post(Url, data=InputCollection, headers={'content-type': 'application/x-www-form-urlencoded'})
        except requests.ConnectionError:
            raise Exception(u'请求出现错误!')
        text = json.loads(resp.text)
        return GatewayResponse(resp.status_code, text['error_code'], text['msg'])


# env = get_env()
# webservice_tns = env['ir.config_parameter'].sudo().get_param('webservice_tns')
# print webservice_tns
# TODO 改为可配置的项目
webservice_tns = 'http://example.com/soap/'
application = Application([JdgService], webservice_tns, in_protocol=Soap11(validator='lxml'), out_protocol=Soap11())
wsgi_application = SOAPWsgiApplication(application)
