# -*- coding: utf-8 -*-
import calendar
import datetime
import logging
import time
import pytz
from odoo import tools

logger = logging.getLogger(__name__)


# 类定义
class dateutils(object):
    """
    日期类工具
    引用:from tools.oegun.utils.dateutils import dateutils as dt
    """

    @staticmethod
    def get_str_cur_month(str_cur_date):
        """
        通过当前的日期取出当前月份
        :param str_cur_date: 日期参数 timetuple
        :return: 日期{str类型}
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        res = datetime.date(year, month, 1).strftime("%Y-%m")
        return res

    @staticmethod
    def get_str_cur_month_first_day(str_cur_date):
        """
        取出当前月份的第一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        res = datetime.date(year, month, 1).strftime("%Y-%m-%d")
        return res

    @staticmethod
    def get_str_next_month_first_day(str_cur_date):
        """
        取出下一个月份的第一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        if month == 12:
            month = 1
            year += 1
        else:
            month += 1
        res = datetime.date(year, month, 1).strftime("%Y-%m-%d")
        return res

    @staticmethod
    def get_str_next_month_last_day(str_cur_date):
        """
        取出下一个月份的最后一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        if month == 12:
            month = 1
            year += 1
        else:
            month += 1
        last_day_num = calendar.monthrange(year, month)
        res = datetime.date(year, month, last_day_num[1]).strftime("%Y-%m-%d")
        return res

    @staticmethod
    def get_str_last_month_first_day(str_cur_date):
        """
        取出上一个月份的第一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        if month == 1:
            month = 12
            year -= 1
        else:
            month -= 1
        res = datetime.date(year, month, 1).strftime("%Y-%m-%d")
        return res

    @staticmethod
    def get_str_this_week_first_day(str_cur_date):
        """
        取出本周的第一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = datetime.datetime.strptime(str_cur_date, "%Y-%m-%d")
        this_week_start = cur_date - datetime.timedelta(days=cur_date.weekday())
        return this_week_start

    @staticmethod
    def get_str_this_week_last_day(str_cur_date):
        """
        取出本周的最后一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = datetime.datetime.strptime(str_cur_date, "%Y-%m-%d")
        this_week_end = cur_date + datetime.timedelta(days=6-cur_date.weekday())
        return this_week_end

    @staticmethod
    def get_str_last_week_first_day(str_cur_date):
        """
        取出上周的第一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = datetime.datetime.strptime(str_cur_date, "%Y-%m-%d")
        this_week_start = cur_date - datetime.timedelta(days=cur_date.weekday() + 7)
        return this_week_start

    @staticmethod
    def get_str_last_week_last_day(str_cur_date):
        """
        取出上周的最后一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = datetime.datetime.strptime(str_cur_date, "%Y-%m-%d")
        this_week_end = cur_date - datetime.timedelta(days=cur_date.weekday() + 1)
        return this_week_end

    @staticmethod
    def get_str_last_month_last_day(str_cur_date):
        """
        取出上一个月份的最后一天
        :param str_cur_date: 日期参数 字符串日期,如:'2017-01-05'
        :return: 字符串日期
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        if month == 1:
            month = 12
            year -= 1
        else:
            month -= 1
        last_day_num = calendar.monthrange(year, month)
        res = datetime.date(year, month, last_day_num[1]).strftime("%Y-%m-%d")
        return res

    @staticmethod
    def get_str_cur_month_last_day(str_cur_date):
        """
        取出当前月份的最后一天
        :param str_cur_date: 日期参数 timetuple
        :return: 日期
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        last_day_num = calendar.monthrange(year, month)

        last_day = datetime.date(year, month, last_day_num[1]).strftime("%Y-%m-%d")
        return last_day

    @staticmethod
    def get_str_this_year_first_day(str_cur_date):
        """
        取本年第一天
        :return: 
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        this_year_first_day = datetime.date(year, 1, 1).strftime('%Y-%m-%d')
        return this_year_first_day
        
    @staticmethod
    def get_1sf_cur_month(cur_date):
        """
        取出当前月份的第一天
        :param cur_date: 日期参数 timetuple
        :return: 日期
        """

        year = cur_date.tm_year
        month = cur_date.tm_mon
        res = datetime.date(year, month, 1)
        return res

    @staticmethod
    def get_1sf_next_month(cur_date):
        """
        取出下一个月份的第一天
        :param cur_date: 日期参数 timetuple
        :return: 日期
        """
        year = cur_date.tm_year
        month = cur_date.tm_mon
        if month == 12:
            month = 1
            year += 1
        else:
            month += 1
        res = datetime.date(year, month, 1)
        return res

    @staticmethod
    def get_end_cur_month(cur_date):
        """
        取出当前月份的最后一天
        :param cur_date: 日期参数 timetuple
        :return: 日期
        """
        year = cur_date.tm_year
        month = cur_date.tm_mon
        last_day_num = calendar.monthrange(year, month)

        last_day = datetime.date(year, month, last_day_num[1])
        return last_day

    @staticmethod
    def get_end_next_month(cur_date):
        """
        取出下一个月份的最后一天
        :param cur_date: 日期参数 timetuple
        :return: 日期
        """
        year = cur_date.tm_year
        month = cur_date.tm_mon
        if month == 12:
            month = 1
            year += 1
        else:
            month += 1
        last_day_num = calendar.monthrange(year, month)

        last_day = datetime.date(year, month, last_day_num[1])
        return last_day

    @staticmethod
    def timetostr(str_cur_date):
        """
        取出当前日期,转成日期类型
        :param str_cur_date: 日期参数 timetuple
        :return: 日期
        """
        cur_date = time.strptime(str_cur_date, "%Y-%m-%d")
        year = cur_date.tm_year
        month = cur_date.tm_mon
        day = cur_date.tm_mday
        cur_day1 = datetime.date(year, month, day).strftime("%Y-%m-%d")
        return cur_day1

    @staticmethod
    def date_from_str(date_str, formatter='%Y-%m-%d'):
        '''
        字符串转为时间
        :param date_str:
        :param formatter: 默认格式'%Y-%m-%d'
        :return: datetime
        '''
        cur_date = datetime.datetime.strptime(date_str, formatter)
        return cur_date

    @staticmethod
    def date_to_str(date_from, formatter='%Y-%m-%d'):
        '''
        日期转为字符串
        :param date_from:
        :param format:
        :return:
        '''
        result = datetime.datetime.strftime(date_from, formatter)
        return result

    @staticmethod
    def time_to_str(src_time=datetime.datetime.utcnow() + datetime.timedelta(hours=8), formatter='%H:%M:%S'):
        '''
        时间转为字符串
        :param self:
        :param src_time:
        :param formatter:
        :return:
        '''
        return datetime.datetime.strftime(src_time, formatter)

    @staticmethod
    def get_date_time(time_str):
        tmp_date = datetime.strptime(time_str, tools.DEFAULT_SERVER_DATETIME_FORMAT)
        # 时区加8个小时 2016-11-16 15:40:06+08:00
        tmp_date = tmp_date.replace(tzinfo=pytz.timezone('UTC')).astimezone(
            pytz.timezone('Asia/Shanghai'))
        # 2016-11-16 11:00:00
        time_str = tmp_date.strftime(tools.DEFAULT_SERVER_DATETIME_FORMAT)
        return time_str

    @staticmethod
    def current_month_get():
        return datetime.datetime.now().month

    @staticmethod
    def current_year_get():
        return datetime.datetime.now().year

    @staticmethod
    def getMonthFirstDayTimeAndLastDayTime(year=None, month=None):
        """
        获取某月某一的头一天和最后一天
        :param year: 年份，默认是本年，可传int或str类型
        :param month: 月份，默认是本月，可传int或str类型
        :return: firstDay: 当月的第一天，datetime.date类型
                  lastDay: 当月的最后一天，datetime.date类型
        """
        if year:
            year = int(year)
        else:
            year = datetime.date.today().year

        if month:
            month = int(month)
        else:
            month = datetime.date.today().month

        # 获取当月第一天的星期和当月的总天数
        firstDayWeekDay, monthRange = calendar.monthrange(year, month)

        # 获取当月的第一天和最后一天
        firstDay = str(year) + "-" + str(month) + "-1 00:00:00"
        lastDay = str(year) + "-" + str(month) + "-" + str(monthRange) + " 23:59:59"

        return firstDay, lastDay

    @staticmethod
    def dateTimeStrToken():
        return datetime.datetime.now().strftime('%Y%m%d%H%M%S')

    @staticmethod
    def time_fix(old_time, time_delta):
        '''
        数据库中取出的时间修复：加8小时
        :param old_time:
        :param time_delta:
        :return:
        '''
        return (datetime.datetime.strptime(old_time, "%Y-%m-%d %H:%M:%S") + datetime.timedelta(
            hours=time_delta)).strftime("%Y-%m-%d %H:%M:%S")

