# -*- coding: utf-8 -*-
import logging
from odoo.http import Response
import simplejson
import functools
import re

_logger = logging.getLogger(__name__)


def remote(func):
    '''
    标注方法，表示远程方法，调用完本地方法之后，会再调用远程方法。
    :param func:
    :return:
    '''

    def wrap(self, *args, **kwargs):
        result_local = func(self, *args, **kwargs)
        result_remote = None
        if hasattr(self, 'ids') and self.ids:
            result_remote = self._json_call(func.func_name, [self.ids, args], kwargs)
        else:
            result_remote = self._json_call(func.func_name, args, kwargs)
        return result_remote

    return wrap


# def rest():
#     def decorator(func):
#         @functools.wraps(func)
#         def wrapper(*args, **kwargs):
#             try:
#                 func(*args, **kwargs)
#             except Exception as e:
#                 result = {
#                     'success': False,
#                     'msg': u'服务器异常',
#                     'data': {},
#                     'error_code': 'server.internal.error'
#                 }
#                 _logger.error(
#                     u'服务器异常：' + e.message + '。\n异常类型：' + e.__class__.__name__ + '。异常信息：' + e.__str__())
#                 return Response(simplejson.dumps(result), status=500)
#
#         return wrapper
#
#     return decorator


def handle_gateway_exception(_logger=_logger):
    '''
    统一对未捕捉的异常进行处理
    :param _logger: 
    :return: 
    '''
    def decorator(func):
        @functools.wraps(func)
        def wrapper(self, *args, **kwargs):
            try:
                return func(self, *args, **kwargs)
            except Exception as e:
                result = {
                    'success': False,
                    'msg': u'发生异常:%s' % e.message,
                    'data': {},
                }
                _logger.error(
                    u'网关调用方法异常：' + str(e.message) + '。\n异常类型：' + e.__class__.__name__ + '。异常信息：' + str(e.__str__()))
                return result

        return wrapper

    return decorator


# decorator
def exec_todo(func):
    def wrapper(*args, **kwargs):
        self = args[0]
        cr = self.env.cr
        user_id = kwargs.get('user_id', False) or self.env.user.id
        company_id = self.env.user.company_id.id
        sql = func(*args, **kwargs)

        # 剔除计算逾期逻辑
        if not kwargs.get('is_compute_overdue'):
            sql = re.sub(r'content,[\s\S]*date_due', 'content', sql, re.I)

        # 参数值替换
        param_value = self.env['jd.todo.task'].get_param_value(func.__name__)
        for key, value in param_value.items():
            sql = sql.replace('{{%s}}' % key, value)

        sql %= {'user_id': user_id, 'company_id': company_id}

        # 构架count计算函数
        # sql_count = sql[:]
        # distinct_list = re.findall('distinct on .*\)', sql_count, re.I)
        # if distinct_list:
        #     sql_count = re.sub(r'SELECT[\s\S]*FROM', 'SELECT %s COUNT(*) FROMM' % distinct_list[0], sql_count, re.I)
        # else:
        #     sql_count = re.sub(r'SELECT[\s\S]*FROM', 'SELECT COUNT(*) FROM', sql_count, re.I)
        #
        # print sql_count

        cr.execute(sql)
        return cr.dictfetchall()

    return wrapper
