# -*- coding: utf-8 -*-
import logging
from odoo.api import call_kw
import simplejson
from odoo import http
from core.middleware.template import TemplateTools

_logger = logging.getLogger(__name__)


class F7Controller(http.Controller):
    @http.route('/f7/demo')
    def f2demo(self, **kwargs):
        tmpl = TemplateTools(__file__)
        env = http.request.env
        pre_sale_order_model = env['jd.bc.sal.pre.sale.order']
        default_values = pre_sale_order_model.default_get(['customer_id', 'name', 'id', 'state'])

        values = {
            'id': False,
            'state': 'draft',
            'customer_id': 22,
            'name': ''
        }
        change_field_name = 'customer_id'
        changed_fields = {
            'id': '',
            'state': '',
            'customer_id': '1',
            'name': ''
        }
        result = pre_sale_order_model.browse().onchange(values, change_field_name, changed_fields)

        pre_sale_wizard_model = env['jd.bc.sal.confirm.pre.order.wizard']

        default_fields = ['id', 'pre_sale_order_id', 'customer_id', 'item_ids.product_id']
        pre_sale_order_id = 37
        default_values = pre_sale_wizard_model.with_context({'active_id': pre_sale_order_id}).default_get(
            default_fields)
        changed_fields = {
            'id': '',
            'pre_sale_order_id': '1',
            'customer_id': '',
            'item_ids': '0',
            'item_ids.product_id': '0',
            'item_ids.package_id': '0',
            'item_ids.package_qty': '0',
            'item_ids.merged_pkg_qty': '0',
            'item_ids.qty': '0',
            'item_ids.merged_qty': '0',
            'item_ids.price': '0',
            'item_ids.need_date': '0',
            'item_ids.need_time': '0',
            'item_ids.uom_id': '0',
            'item_ids.product_level_id': '0',
            'item_ids.pre_sale_line_id': '0',
            'item_ids.line_amount': '0',
            'item_ids.remark': '0',
            'item_ids.merged': '0',
            'item_ids.merged_to_line_id': '0',
            'item_ids.merged_to_order_id': '0',
            'item_ids.sale_group_id': '0',
        }
        default_values.update({'item_ids': [], 'customer_id': 0})
        after_onchange = pre_sale_wizard_model.browse().onchange(default_values, 'pre_sale_order_id', changed_fields)
        dict_values = after_onchange['value']
        dict_values.update({'pre_sale_order_id': pre_sale_order_id})


        def extract_values(origin_value):
            if isinstance(origin_value, list):
                for item in origin_value:
                    extract_values(item)
            elif isinstance(origin_value, dict):
                for _key, _v in origin_value.items():
                    if isinstance(_v, tuple) and len(_v) == 2:
                        origin_value.update({_key: _v[0]})  # many2one的情况,只取id
                    elif isinstance(_v, list):  # one2many的情况,[[len], [record1,recored2]]
                        extract_values(_v)
            elif isinstance(origin_value, tuple) and isinstance(origin_value[len(origin_value) - 1], dict):
                extract_values(origin_value[len(origin_value) - 1])

        extract_values(dict_values)
        new_wizard = pre_sale_wizard_model.create(dict_values)
        context = {}
        result = call_kw(pre_sale_wizard_model, 'on_confirm', [new_wizard.id], context)
        return tmpl.render('index.html')
