odoo.define('barcode_widget.form_widgets', function (require) {
    "use strict";

    var core = require('web.core');
    var form_common = require('web.form_common');
    var FieldChar = core.form_widget_registry.get('char');

    var Barcode128Widget = FieldChar.extend({
        template: 'Barcode128Widget',
        render_value: function () {
            var show_value = this.format_value(this.get('value'), '');
            if (this.$input) {
                if (!this.$el.hasClass('hide_number'))
                    this.$input.val(show_value);
            } else {
                var $barcodelink = this.$el.find('a');
                if (!this.$el.hasClass('hide_number')) {
                    var $barcodeval = this.$el.find('span')
                    $barcodeval.text(show_value);
                    $barcodeval.attr("style", 'display:block; text-align: center;')
                }
                var barcode_path = '/report/barcode/Code128/' + show_value + '?width=350&height=50';
                $barcodelink.attr("href", barcode_path);
                var $barcode = this.$el.find('img');
                $barcode.attr("src", barcode_path);
            }
        }
    });
    core.form_widget_registry.add('BarCode128', Barcode128Widget);
});
