odoo.define('jd_webcam.webcam_widget', function (require) {
    "use strict";

    var core = require('web.core');
    var Model = require('web.Model');
    var Dialog = require('web.Dialog');

    var _t = core._t;
    var QWeb = core.qweb;

    core.form_widget_registry.get("image").include({

        render_value: function () {
            this._super();

            var self = this,
                WebCamDialog = $(QWeb.render("WebCamDialog")),
                img_data;

            Webcam.set({
                width: 320,
                height: 240,
                dest_width: 320,
                dest_height: 240,
                image_format: 'jpeg',
                jpeg_quality: 90,
                force_flash: false,
                fps: 45,
                swfURL: '/jd_webcam/static/src/js/webcam.swf',
            });

            self.$el.find('.o_form_binary_file_web_cam').removeClass('col-md-offset-5');

            new Model('ir.config_parameter').call('get_param', ['jd_webcam.flash_fallback_mode', false]).then(function (default_flash_fallback_mode) {
                if (default_flash_fallback_mode == 1) {
                    Webcam.set({
                        force_flash: true,
                    });
                }
            });

            self.$el.find('.o_form_binary_file_web_cam').off().on('click', function () {
                new Dialog(self, {
                    size: 'large',
                    dialogClass: 'o_act_window',
                    title: _t("拍照"),
                    $content: WebCamDialog,
                    buttons: [
                        {
                            text: _t("拍摄"), classes: 'btn-primary take_snap_btn',
                            click: function () {
                                Webcam.snap(function (data) {
                                    img_data = data;
                                    WebCamDialog.find("#webcam_result").html('<img src="' + img_data + '"/>');
                                });
                                $('.save_close_btn').removeAttr('disabled');
                            }
                        },
                        {
                            text: _t("保存 & 关闭"), classes: 'btn-primary save_close_btn', close: true,
                            click: function () {
                                var img_data_base64 = img_data.split(',')[1];
                                var approx_img_size = 3 * (img_data_base64.length / 4)
                                self.on_file_uploaded(approx_img_size, "web-cam-preview.jpeg", "image/jpeg", img_data_base64);
                            }
                        },
                        {
                            text: _t("关闭"), close: true
                        }
                    ]
                }).open();
                Webcam.attach('#live_webcam');
                $('.save_close_btn').attr('disabled', 'disabled');
                WebCamDialog.find("#webcam_result").html('<img src="/jd_webcam/static/src/img/webcam_placeholder.png"/>');
            });
        },
    });

    Dialog.include({
        destroy: function () {
            Webcam.reset();
            this._super.apply(this, arguments);
        },
    });
});
