# -*- coding: utf-8 -*-
# Copyright 2018 JDG <www.yunside.com>
# Created by carmen <jiawen.ling@yunside.com> at 2018/11/28

from odoo import models, fields, api
from odoo.exceptions import ValidationError
from odoo.osv import expression
import datetime


class WizardReportPrint(models.TransientModel):
    _name = 'jd.rpt.wizard.report.print'
    _description = u'玉龙打印格式'
    _order = 'id asc'

    report_size = fields.Many2one('ir.actions.report.xml', string=u'打印格式', required=True,
                                  domain=lambda self: [('model', '=', self.env.context.get('model_name', None))])

    @api.model
    def default_get(self, fields):
        """
        根据xml传来的context的值，report_size
        :param fields:
        :return:
        """
        res = super(WizardReportPrint, self).default_get(fields)
        model_name = self.env.context.get('model_name', None)
        report_size_objs = self.env['ir.actions.report.xml'].sudo().search([('model', '=', model_name)])
        if len(report_size_objs) != 0:
            report_size_id = report_size_objs[0].id
        else:
            report_size_id = None
        if 'report_size' in fields:
            res.update({'report_size': report_size_id})
        return res

    @api.multi
    def do_confirm(self):
        url = "/report/pdf/%s/%d" % (self.report_size.report_name, self.env.context.get('bill_id', None))
        return {
            'type': 'ir.actions.act_url',
            'url': url,
            'target': 'new',
        }
