# -*- coding:utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 11/4/19

from odoo import models, fields, api
from odoo.exceptions import ValidationError
from odoo.osv import expression
import datetime


class WizardEditXml(models.TransientModel):
    _name = 'jd.rpt.wizard.edit.xml'
    _description = u'编辑向导xml'
    _order = 'id asc'

    datasource_id = fields.Many2one('jd.table.datasource', string=u'数据源', readonly=True)
    search_view = fields.Many2one('ir.ui.view', string=u'向导视图', readonly=True)
    xml = fields.Text(string=u'xml视图')
    # report_size = fields.Many2one('ir.actions.report.xml', string=u'打印格式', required=True,
    #                               domain=lambda self: [('model', '=', self.env.context.get('model_name', None))])

    @api.model
    def default_get(self, fields):
        """
        :return:
        """
        res = super(WizardEditXml, self).default_get(fields)
        active_id = self.env.context.get('active_id', None)
        datasource = self.env['jd.table.datasource'].browse(active_id)
        search_view = datasource.search_view
        xml = ""
        if search_view:
            xml = search_view.arch_base
        res.update({'datasource_id': active_id, 'xml': xml,
                    'search_view': search_view.id})
        return res

    @api.multi
    def do_confirm(self):
        """
        :return:
        """
        for item in self:
            item.search_view.write({'arch_base': item.xml})
            item.datasource_id.write({'form_view_code': item.xml})