# -*- coding: utf-8 -*-

import logging

from odoo import fields, models
from odoo import api
import simplejson
_logger = logging.getLogger(__name__)


class WizardModelMenu(models.TransientModel):
    _name = 'jd.wizard.create.report.menu'

    type = fields.Selection([('edit', u'发布到已有菜单'),
                             ('create', u'新建菜单')], string=u'发布类型', default='create', required=True)
    exist_menu_id = fields.Many2one('ir.ui.menu', string=u'已有菜单')
    menu_id = fields.Many2one('ir.ui.menu', string=u'父菜单', ondelete='cascade')
    name = fields.Char(string=u'菜单名称')
    sequence = fields.Integer(string=u'Sequence')

    @api.multi
    def do_confirm(self):
        for menu in self:
            report_id = self._context.get('active_id')
            report = self.env['jd.table.report'].browse(int(report_id))
            action_id = None
            if report.datasource_id:
                model = report.datasource_id.search_model
                vals = {
                    'name': menu.name or menu.exist_menu_id.name,
                    'res_model': model.model,
                    'view_mode': 'tree,form',
                    'view_type': 'form',
                    'target': 'new',
                    'view_id': report.datasource_id.search_view.id or None,  # 打开对应的过滤条件视图。
                    'context': simplejson.dumps({'report_id': report.id, 'datasource_id': report.datasource_id.id})
                }
                action_id = self.env['ir.actions.act_window'].create(vals)
            if menu.type == 'create':
                menu = self.env['ir.ui.menu'].create({
                    'name': menu.name,
                    'parent_id': menu.menu_id.id,
                    'action': 'ir.actions.act_window,%d' % (action_id,)
                })
                menu_vals = [(0, 0, {
                    'menu_id': menu.id,
                    'type': 'create'
                })]
                report.menu_ids = menu_vals
                # self.env.cr.execute("insert into jd_report_menu_ref(report_id, menu_id) values(%s,%s)" % (report.id, menu.id))
            elif menu.type == 'edit':
                menu = menu.exist_menu_id
                menu.write({
                    'action': 'ir.actions.act_window,%d' % (action_id,)
                })
                rec = self.env['ir.model.data'].sudo().search([('model', '=', 'ir.ui.menu'),
                                                               ('res_id', '=', menu.id)], limit=1)
                external_id = ''
                if rec:
                    external_id = rec.complete_name
                menu_vals = [(0, 0, {
                    'menu_id': menu.id,
                    'type': 'edit',
                    'external_id': external_id
                })]
                report.menu_ids = menu_vals
                # self.env.cr.execute(
                #     "insert into jd_report_menu_ref(report_id, menu_id) values(%s,%s)" % (report.id, menu.id))
            report.write({
                'state': 'confirm'
            })
