# -*- coding:utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 11/4/19

from odoo import models, fields, api
from odoo.exceptions import ValidationError
from odoo.osv import expression
import datetime


class WizardComputeMethod(models.TransientModel):
    _name = 'jd.rpt.wizard.compute.method'
    _description = u'compute方法向导'
    _order = 'id asc'

    datasource_id = fields.Many2one('jd.table.datasource', string=u'数据源', readonly=True)
    line_id = fields.Many2one('jd.table.params', string=u'关联参数明细', readonly=True)
    method_code = fields.Text(string=u'方法代码')

    @api.model
    def default_get(self, fields):
        """
        :return:
        """
        res = super(WizardComputeMethod, self).default_get(fields)
        line = None
        active_id = self.env.context.get('active_id', None)
        line = self.env['jd.table.params'].browse(active_id)
        datasource_id = line.datasource_id.id
        method_code = ""
        if line:
            method_code = line.compute
        res.update({'datasource_id': datasource_id,
                    'line_id': line.id if line else False,
                    'method_code': method_code})
        return res

    @api.multi
    def do_confirm(self):
        """
        :return:
        """
        for item in self:
            item.datasource_id.params = [(1, item.line_id.id, {'compute': item.method_code})]