# -*- coding:utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 11/2/19
from jinja2 import Environment, FileSystemLoader

import os


class TPL_Engine(object):
    '''
    JINJIA2模板工具加载类
    '''
    _environment = None

    def __init__(self, path='/data/template'):
        BASE_DIR = os.path.dirname(os.path.dirname(__file__))
        loader = FileSystemLoader(searchpath=BASE_DIR + path)
        self._environment = Environment(loader=loader)

    def render(self, template, *args, **kwargs):
        template = self._environment.get_template(template)
        return template.render(*args, **kwargs)