# -*- coding: utf-8 -*-

import logging
import time
from datetime import datetime
from odoo.tools.mail import html2plaintext

from odoo import fields, models, api, exceptions
import pytz
from odoo import tools
import re
_logger = logging.getLogger(__name__)


class TableReportCell(models.Model):
    _name = 'jd.table.report.cell'
    _description = u'报表元素定义'
    
    @api.model
    def render(self):
        '''
        根据element_def，封装data成页面可以展示的数据
        :return:
        '''
        data = []
        element_def = []
        final_data = []
        cell_def= {
            'report_id': 0,
            'row_index': 0,
            'col_index': 0,
            'style':'',
            'value': '组织'
        }
        cell_def1 = {
            'report_id': 0,
            'row_index': 0,
            'col_index': 1,
            'style': '',
            'value': '客户'
        }
        cell_def2 = {
            'report_id': 0,
            'row_index': 0,
            'col_index': 2,
            'style': '',
            'value': '产品'
        }
        cell_def3 = {
            'report_id': 0,
            'row_index': 0,
            'col_index': 3,
            'style': '',
            'value': '数量'
        }
        cell_def4 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 0,
            'style': '',
            'value': '=group(org)'
        }
        cell_def5 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 1,
            'style': '',
            'value': '=group(customer)'
        }
        cell_def6 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 2,
            'style': '',
            'value': '=product'
        }
        cell_def7 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 3,
            'style': '',
            'value': '=qty'
        }
        cell_def8 = {
            'report_id': 0,
            'row_index': 2,
            'col_index': 0,
            'style': '',
            'value': '合计'
        }
        cell_def_sum = {
            'report_id': 0,
            'row_index': 2,
            'col_index': 3,
            'style': '',
            'value': '=sum(3,2)',
            'merge': '(1,2),(3,2)'
        }

        cell_list = [cell_def,cell_def1,cell_def2,cell_def3,cell_def4,cell_def5,cell_def6,cell_def7,cell_def8,cell_def_sum]
        data_item = {
            'org':'联营服务部',
            'customer': '海涛',
            'product': '竹丝鸡1号',
            'qty': 2323,
        }
        data_item1 = {
            'org': '联营服务部',
            'customer': '海涛',
            'product': '竹丝鸡2号',
            'qty': 433,
        }
        data_item2 = {
            'org': '联营服务部',
            'customer': '海涛',
            'product': '竹丝鸡3号',
            'qty': 1,
        }
        data_item3 = {
            'org': '联营服务部',
            'customer': '孟定',
            'product': '矮脚黄',
            'qty': 1,
        }
        data_item4 = {
            'org': '开阳服务部',
            'customer': '涛涛',
            'product': '竹丝鸡1号',
            'qty': 43,
        }
        data_item5 = {
            'org': '联营服务部',
            'customer': '海涛',
            'product': '竹丝鸡14号',
            'qty': 43,
        }
        data_item6 = {
            'org': '开阳服务部',
            'customer': '海涛2',
            'product': '竹丝鸡15号',
            'qty': 3,
        }
        data_list = [data_item, data_item1,data_item2,data_item3,data_item4,data_item5,data_item6]
        cell_list = self.translate_cell_def_to_row(cell_list)
        group_func_reg = r'=group\((\w+)\)'
        #把分组的列先找出路，再把数据分组
        group_fields = []
        for row in cell_list:
            for col in row:
                cell_val = col['value']
                group_pattern = re.compile(group_func_reg)
                matcher = re.search(group_pattern, cell_val)
                field_name = matcher.group(1)




    @api.model
    def translate_cell_def_to_row(self, cell_list):
        '''
        把行列定义转成行列二维数组，行是第-维，列为第二维。比例[row1,row2,row3,row4]这样。
        row的数据格式:[{value:'',report_id:xx,row_index:23,col_index:32,style:'xxx',origin_value:'xx'}，{value:'',report_id:xx,row_index:23,col_index:32,style:'xxx',origin_value:'xx'}]
        :param cell_list: 报表元素定义列表[{report_id:xx,row_index:xx,col_index:32,style:'2323',value:'=group(aaa,bb)'}]
        :return:[row1,row2,row3,row4], row:[column1, column2,column3], column格式：{value:'',report_id:xx,row_index:23,col_index:32,style:'xxx',origin_value:'xx'}
        '''
        final_data = []
        max_row, max_col = self.get_max_row_column_index(cell_list)
        for row_index in xrange(0, max_row+1):
            row_list = []
            for col_index in xrange(0, max_col+1):
                row_list.append({})
            final_data.append(row_list)

        for cell in cell_list:
            row_index = cell['row_index']
            col_index = cell['col_index']
            final_data[row_index][col_index].update(cell)

        return final_data

    @api.model
    def get_max_row_column_index(self, cell_list):
        '''
        获取最大行和列下标
        :param cell_list: [{report_id:xx,row_index:xx,col_index:32,style:'2323',value:'=group(aaa,bb)'}]
        :return: max row, max column
        '''
        max_row = 0
        max_col = 0
        for cell in cell_list:
            if max_row < cell['row_index']:
                max_row = cell_list['row_index']
            if max_col < cell['col_index']:
                max_col = cell['col_index']
        return max_row, max_col