# -*- coding: utf-8 -*-

import os
import re
import urllib

from lxml import etree

import odoo
import odoo.tools as tools
from odoo.report.interface import print_xml
from odoo.report.interface import render
from odoo.modules import get_module_resource


class jdg_report_rml(odoo.report.interface.report_rml):
    """
        Automatically builds a document using the transformation process:
            XML -> DATAS -> RML -> PDF -> HTML
        using a XSL:RML transformation
    """

    def create(self, cr, uid, ids, datas, context=None):
        env = odoo.api.Environment(cr, uid, context or {})
        xml = self.create_xml(cr, uid, ids, datas, context)
        xml = tools.ustr(xml).encode('utf8')
        report_type = datas.get('report_type', 'pdf')
        if report_type == 'raw':
            return xml, report_type

        env['res.font'].sudo().font_scan(lazy=True)

        rml = self.create_rml(cr, xml, uid, context)
        reports = env['ir.actions.report.xml'].search([('report_name', '=', self.name[7:])])
        # self.title = reports[0].name if reports else '[玉龙科技报表系统]'
        create_doc = self.generators[report_type]
        # pdf = create_doc(rml, title=self.title)
        pdf = create_doc(rml)
        return pdf, report_type
