# -*- coding: utf-8 -*-

import logging
import re
import copy

class TableReportCell:

    def render(self):
        print 'start render'
        '''
        根据element_def，封装data成页面可以展示的数据
        :return:
        '''
        data = []
        element_def = []
        final_data = []
        cell_def = {
            'report_id': 0,
            'row_index': 0,
            'col_index': 0,
            'style': '',
            'value': u'组织'
        }
        cell_def1 = {
            'report_id': 0,
            'row_index': 0,
            'col_index': 1,
            'style': '',
            'value': u'客户'
        }
        cell_def2 = {
            'report_id': 0,
            'row_index': 0,
            'col_index': 2,
            'style': '',
            'value': u'产品'
        }
        cell_def3 = {
            'report_id': 0,
            'row_index': 0,
            'col_index': 3,
            'style': '',
            'value': u'数量'
        }
        cell_def4 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 0,
            'style': '',
            'value': '=group(org)'
        }
        cell_def5 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 1,
            'style': '',
            'value': '=group(customer)'
        }
        cell_def6 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 2,
            'style': '',
            'value': '=product'
        }
        cell_def7 = {
            'report_id': 0,
            'row_index': 1,
            'col_index': 3,
            'style': '',
            'value': '=qty'
        }
        cell_def8 = {
            'report_id': 0,
            'row_index': 2,
            'col_index': 0,
            'style': '',
            'value': u'合计'
        }
        cell_def_sum = {
            'report_id': 0,
            'row_index': 2,
            'col_index': 3,
            'style': '',
            'value': '=sum(3,2)',
            'merge': '(1,2),(3,2)'
        }

        cell_list = [cell_def, cell_def1, cell_def2, cell_def3, cell_def4, cell_def5, cell_def6, cell_def7, cell_def8,
                     cell_def_sum]
        data_item = {
            'org': u'A服务部',
            'customer': u'海涛',
            'product': u'竹丝鸡1号',
            'qty': 2323,
            'index': 0
        }
        data_item1 = {
            'org': u'A服务部',
            'customer': u'海涛',
            'product': u'竹丝鸡2号',
            'qty': 433,
            'index': 1
        }
        data_item2 = {
            'org': u'A服务部',
            'customer': u'海涛',
            'product': u'竹丝鸡3号',
            'qty': 1,
            'index': 2
        }
        data_item3 = {
            'org': u'A服务部',
            'customer': u'孟定',
            'product': u'矮脚黄',
            'qty': 1,
            'index': 3
        }
        data_item4 = {
            'org': u'B服务部',
            'customer': u'涛涛',
            'product': u'竹丝鸡1号',
            'qty': 43,
            'index': 4
        }
        data_item5 = {
            'org': u'A服务部',
            'customer': u'海涛',
            'product': u'竹丝鸡14号',
            'qty': 43,
            'index': 5
        }
        data_item6 = {
            'org': u'A服务部',
            'customer': u'海涛2',
            'product': u'竹丝鸡15号',
            'qty': 3,
            'index': 6
        }
        data_list = [data_item, data_item1, data_item2, data_item3, data_item4, data_item5, data_item6]
        cell_list = self.translate_cell_def_to_row(cell_list)
        group_fields = self.get_group_fields(cell_list)
        print 'group fields:', group_fields
        print 'data list before group:', data_list
        self.group_data(group_fields, data_list)
        print 'data list after group:', data_list

        index = 0
        pre_row_data = None
        while index < len(cell_list):
            row = cell_list[index]
            if self.is_list_row(row):
                del cell_list[index]
                for data in data_list:
                    row_def = copy.deepcopy(row)  # 会修改成数据行
                    self.render_row(row_def, pre_row_data, data, group_fields)
                    pre_row_data = row_def
                    cell_list.insert(index, row_def)
                    index += 1
                if not data_list:
                    index += 1
            else:
                index += 1

        print 'cell_list', cell_list

    def render_row(self, row_def, pre_row, current_row_data, group_fields):
        '''
        根据行定义，填充行数据。该方法会修改row_def的值。
        :param row_def: 行定义
        :param pre_row: 行列二维数组
        :param current_row_data: 行数据
        :return:
        '''
        col_length = len(row_def)
        for i in xrange(0, col_length):
            col = row_def[i]
            def_val = col['value']
            field_name = self.get_field_name_from_def(def_val)
            pre_val = None
            field_val = None
            if pre_row and field_name in pre_row[i].keys():
                pre_val = pre_row[i][field_name]
            if field_name in current_row_data.keys():
                field_val = current_row_data[field_name]
                col['original_value'] = col['value']
                col['value'] = field_val
            if field_name in group_fields:
                if pre_val == field_val:
                    col['group_pre'] = 1 #和前一行在同一分组。
                else:
                    col['group_pre'] = 0 #和前一行在不同分组



    def get_field_name_from_def(self, def_val):
        '''
        从元素定义值中获取字段名
        :param def_val:
        :return:
        '''
        group_reg = r'=group\((\w+)\)'
        select_reg = r'=select\((\w+)\)'
        field_reg = r'=field\((\w+)\)'
        group_pattern = re.compile(group_reg)
        select_pattern = re.compile(select_reg)
        field_pattern = re.compile(field_reg)
        group_matcher = re.search(group_pattern, def_val)
        select_matcher = re.search(select_pattern, def_val)
        field_matcher = re.search(field_pattern, def_val)
        if group_matcher:
            return group_matcher.group(1)
        elif select_matcher:
            return select_matcher.group(1)
        elif field_matcher:
            return field_matcher.group(1)


    def is_list_row(self, def_row):
        '''
        是否包含列表行, 元素定义为:=group(xxx),=select(xxx),=field(field_name)表示是列表行
        :param def_row:
        :param data_row:
        :return:
        '''
        list_func = ['=group', '=select', '=field']
        for col in def_row:
            if col and 'value' in col.keys():
                val = col['value']
                for func in list_func:
                    if val.startswith(func):
                        return True
        return False

    def group_data(self, group_fields, data_list):
        '''
        数据分组排序，分组后的数据。为了方便表格合并，相同分组中的第一行对应的列有值，后面的值都是''。
        :param group_fields:  分组列名
        :param data_list:
        :return:
        '''

        length = len(data_list)
        for field in group_fields:
            i = 0
            while i < length:
                data = data_list[i]
                current_group_val = data[field]
                for j in xrange(i + 1, length):
                    data_relocation = data_list[j]
                    data_val2 = data_relocation[field]
                    if current_group_val == data_val2:
                        del data_list[j]
                        # 把相同值得数据，排在一起
                        data_list.insert(i + 1, data_relocation)
                        i += 1
                i += 1

    def get_group_fields(self, cell_list):
        '''
        获取分组的字段，分组优先级从高到低排序
        :return:
        '''
        group_func_reg = r'=group\((\w+)\)'
        # 把分组的列先找出路，再把数据分组
        group_fields = []
        for row in cell_list:
            for col in row:
                print col
                if not col or 'value' not in col.keys():
                    continue
                cell_val = col['value']
                group_pattern = re.compile(group_func_reg)
                matcher = re.search(group_pattern, cell_val)
                if matcher:
                    field_name = matcher.group(1)
                    group_fields.append(field_name)
        return group_fields

    def translate_cell_def_to_row(self, cell_list):
        '''
        把行列定义转成行列二维数组，行是第-维，列为第二维。比例[row1,row2,row3,row4]这样。
        row的数据格式:[{value:'',report_id:xx,row_index:23,col_index:32,style:'xxx',origin_value:'xx'}，{value:'',report_id:xx,row_index:23,col_index:32,style:'xxx',origin_value:'xx'}]
        :param cell_list: 报表元素定义列表[{report_id:xx,row_index:xx,col_index:32,style:'2323',value:'=group(aaa,bb)'}]
        :return:[row1,row2,row3,row4], row:[column1, column2,column3], column格式：{value:'',report_id:xx,row_index:23,col_index:32,style:'xxx',origin_value:'xx'}
        '''
        final_data = []
        max_row, max_col = self.get_max_row_column_index(cell_list)
        for row_index in xrange(0, max_row + 1):
            row_list = []
            for col_index in xrange(0, max_col + 1):
                row_list.append({})
            final_data.append(row_list)

        for cell in cell_list:
            row_index = cell['row_index']
            col_index = cell['col_index']
            final_data[row_index][col_index].update(cell)

        return final_data

    def get_max_row_column_index(self, cell_list):
        '''
        获取最大行和列下标
        :param cell_list: [{report_id:xx,row_index:xx,col_index:32,style:'2323',value:'=group(aaa,bb)'}]
        :return: max row, max column
        '''
        max_row = 0
        max_col = 0
        for cell in cell_list:
            if max_row < cell['row_index']:
                max_row = cell['row_index']
            if max_col < cell['col_index']:
                max_col = cell['col_index']
        return max_row, max_col


table = TableReportCell()
table.render()
