# -*- coding: utf-8 -*-
# Created by misterling(jiawen.ling@yunside.com) at 2019/6/10
import logging
import time
from datetime import datetime
from odoo.tools.mail import html2plaintext
from odoo.exceptions import ValidationError
from odoo import fields, models, api, exceptions
import pytz
from odoo import tools
import json

_logger = logging.getLogger(__name__)


class NoticeTodo(models.Model):
    _name = "jd.notice.todo"
    _description = u"待办事项"

    name = fields.Char(u'名称', required=True)
    content_template_name = fields.Char(u'内容模板名称', required=True, index=True)
    model = fields.Many2one('ir.model', string=u'数据来源模型', required=True, index=True)
    method = fields.Char(string=u'数据来源方法', required=True)
    is_enable = fields.Boolean(string=u'是否启用', default=False)

    @api.model
    def create(self, vals):
        todos = self.search([('is_enable', '=', True)], limit=1)
        if len(todos) > 0:
            if 'is_enable' in vals and vals.get('is_enable', None):
                raise ValidationError('只允许有一个启用的内容')
        return super(NoticeTodo, self).create(vals)

    @api.multi
    def write(self, vals):
        self.ensure_one()
        todos = self.search([('is_enable', '=', True)], limit=1)
        if len(todos) > 0:
            if 'is_enable' in vals and vals.get('is_enable', None):
                raise ValidationError('只允许有一个启用的内容')
        return super(NoticeTodo, self).write(vals)

    @api.model
    def get_enable_config(self):
        todo = self.search([('is_enable', '=', True)], limit=1)
        if len(todo) > 0:
            return {
                'contentTemplateName': todo[0].content_template_name,
                'model': todo[0].model.model,
                'method': todo[0].method,
            }

    @api.model
    def get_default_data(self):
        return {'testName': '测试名称'}

    @api.model
    def get_system_config(self, params):
        config_key = params.get('configName', None)
        html = ""
        if config_key:
            html = self.env['ir.config_parameter'].get_param(config_key) or ''
        return html
