# -*- encoding: utf-8 -*-
# 项目：JDG-
# 模块名称：
# 描述：
# Copyright 2018 JDG <www.yunside.com>
# Created by wxh (xianhuo.weng@yunside.com) at  2019/11/25 - 4:40 PM

from odoo import fields, api, models
from odoo.exceptions import ValidationError


CHANNEL = [('sms', u'短信'), ('inner_msg', u'系统消息'), ('mail', u'邮件'), ('qywx', u'企业微信')]
RESULT = [('success', u'成功'), ('fail', u'失败')]


class AbnormalPushRecord(models.Model):
    _name = 'jd.abnormal.push.record'
    _inherit = 'jdg.abstract.base'
    
    abnormal_id = fields.Many2one('jd.abnormal.info', string=u'异常预警', required=True)
    number = fields.Char(string=u'流水号')
    department_type_ids = fields.Char(string=u'岗位')
    user_ids = fields.One2many('res.users', string=u'推送人员列表', compute='_get_user_ids')

    content = fields.Text(string=u'推送内容', required=True)
    channel = fields.Selection(CHANNEL, string=u'推送渠道', required=True)
    result = fields.Selection(RESULT, string=u'推送结果', required=True, default='success')
    create_date = fields.Datetime(string=u'推送时间')
    
    @api.model
    def create(self, values):
        if values.get('number', '/') == '/':
            values.update({
                'number': self.env['ir.sequence'].next_by_code(self._name)
            })
        return super(AbnormalPushRecord, self).create(values)
    
    @api.multi
    def _get_user_ids(self):
        item = self[0]
        item.user_ids = []