# -*- coding: utf-8 -*-
# 项目: jdg-hd-node-farm
# Copyright 2018 JDG <www.yunside.com>
# Created by LLH <lianghua.liu@yunside.com> at 2018/8/9

from odoo import models, fields, api

import logging

_logger = logging.getLogger(__name__)


class VoucherException(models.Model):
    """
    凭证对接异常记录
    捕捉并保存凭证对接过程中的异常记录
    """
    _name = 'jd.int.voucher.exception'
    _description = u'凭证异常记录'

    number = fields.Char(string=u'编码', required=True, default='/')
    voucher_id = fields.Many2one('jd.int.voucher', string=u'凭证定义', required=True)
    time_push = fields.Datetime(string=u'推送时间', required=True)
    uid_push = fields.Many2one('res.users', string=u'推送人')
    reason = fields.Text(string=u'异常原因')
    note = fields.Text(string=u'备注')
    res_order = fields.Reference(string=u'来源单据', selection='_reference_models', readonly=True)

    @api.model
    def _reference_models(self):
        models = self.env['ir.model'].search([('state', '!=', 'manual')])
        return [(model.model, model.name)
                for model in models
                if not model.model.startswith('ir.')]

    @api.model
    def create(self, values):
        """
        获取自动单号
        :param values:
        :return:
        """
        if values.get('number', '/') == '/':
            values.update({
                'number': self.env['ir.sequence'].next_by_code(self._name)
            })
        return super(VoucherException, self).create(values)
