# -*- coding: utf-8 -*-
# 项目: jdg-hd-node-farm
# Copyright 2018 JDG <www.yunside.com>
# Created by LLH <lianghua.liu@yunside.com> at 2018/8/9

from odoo import models, fields, api

import logging

_logger = logging.getLogger(__name__)


class VoucherCategory(models.Model):
    _name = 'jd.int.voucher.category'
    _description = u'凭证分类'

    name = fields.Char(string=u'名称', required=True)
    number = fields.Char(string=u'编码', required=True, readonly=True, default='/')
    description = fields.Char(string=u'业务描述')
    active = fields.Boolean(string=u'有效', default=True)
    note = fields.Text(string=u'备注')

    _sql_constraints = [
        ('name_uniq', 'unique (name)', u'名称不能重复'),
        ('number_uniq', 'unique (number)', u'编码不能重复'),
    ]

    @api.model
    def create(self, values):
        """
        获取自动单号
        :param values:
        :return:
        """
        if values.get('number', '/') == '/':
            values.update({
                'number': self.env['ir.sequence'].next_by_code(self._name)
            })
        return super(VoucherCategory, self).create(values)
