# -*- coding: utf-8 -*-
import os
from odoo import api, fields, models, tools, _
from odoo.exceptions import ValidationError
from odoo.modules import get_resource_path
from odoo import http


class ResCompany(models.Model):
    _inherit = 'res.company'

    def _get_logo(self):
        # image_path = 'jdg_base_app/jd_init/static/img/logo.png'
        # return open(image_path, 'rb').read().encode('base64')
        return open(
            os.path.join(get_resource_path('jd_init'), 'static', 'img', 'res_company_logo.png'),
            'rb').read().encode('base64')

    logo = fields.Binary(related='partner_id.image', default=_get_logo)

    @api.model
    def create(self, values):
        rec = super(ResCompany, self).create(values)
        self.env['res.users'].sudo().browse(1).company_ids = [(4, rec.id)]
        return rec