# -*- coding: utf-8 -*-
from odoo import models, fields, api, modules, tools
from odoo.tools import config
MODULE_DEPLOY_PSD = config.get('modules_deploy_password')


class Module(models.Model):
    _inherit = 'ir.module.module'
    _description = "Module Inherit"

    @api.multi
    def button_install_wizard(self):
        if not MODULE_DEPLOY_PSD:
            return self.button_immediate_install()
        else:
            return {
                'name': u'模块部署密码输入框',
                'type': 'ir.actions.act_window',
                'model': 'ir.actions.act_window',
                'view_type': 'form',
                'view_mode': 'form',
                'res_model': 'jd.init.wizard.module.deploy',
                'target': 'new',
                'view_id': False,
                'context': {
                    'module_id': self.id,
                    'action': 'install'
                }
            }

    @api.multi
    def button_uninstall_wizard(self):
        if not MODULE_DEPLOY_PSD:
            return self.button_uninstall()
        else:
            return {
                'name': '模块部署密码输入框',
                'type': 'ir.actions.act_window',
                'model': 'ir.actions.act_window',
                'view_type': 'form',
                'view_mode': 'form',
                'res_model': 'jd.init.wizard.module.deploy',
                'target': 'new',
                'view_id': False,
                'context': {
                    'module_id': self.id,
                    'action': 'uninstall'
                }
            }

    @api.multi
    def button_upgrade_wizard(self):
        if not MODULE_DEPLOY_PSD:
            return self.button_immediate_upgrade()
        else:
            return {
                'name': '模块部署密码输入框',
                'type': 'ir.actions.act_window',
                'model': 'ir.actions.act_window',
                'view_type': 'form',
                'view_mode': 'form',
                'res_model': 'jd.init.wizard.module.deploy',
                'target': 'new',
                'view_id': False,
                'context': {
                    'module_id': self.id,
                    'action': 'upgrade'
                }
            }
