# -*- coding: utf-8 -*-
from odoo import models, api
from .base_suspend_security import BaseSuspendSecurityUid


class IrRule(models.Model):
    _inherit = 'ir.rule'

    @api.model
    def domain_get(self, model_name, mode='read'):
        if isinstance(self.env.uid, BaseSuspendSecurityUid):
            return [], [], ['"%s"' % self.pool[model_name]._table]

        if self.env.context.get('force_user_with_admin') == self._uid:
            return [], [], ['"%s"' % self.pool[model_name]._table]

        return super(IrRule, self).domain_get(model_name, mode=mode)
