# -*- coding: utf-8 -*-
# @Time    : 5/3/20 10:37 PM
# @Author  : bjccdsrlcr
# @Email   : longjie.jiang@yunside.com
# @File    : ir_http.py
# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

import json
import logging
from odoo import models
from odoo.http import request

import odoo


class Http(models.AbstractModel):
    _inherit = 'ir.http'
    
    def session_info(self):
        user = request.env.user
        display_switch_company_menu = user.has_group('base.group_multi_company') and len(user.company_ids) > 1
        version_info = odoo.service.common.exp_version()
        if display_switch_company_menu:
            cr = request.env.cr
            recent_company = request.env['jd.res.users.recent.company'].get_recent_companys(user.id)
            recent_allowed_company = []
            if recent_company:
                sql = """
                    SELECT
                        rc.id, rc.name
                    FROM res_company_users_rel rel
                    INNER JOIN res_company rc ON rc.id = rel.cid
                    INNER JOIN res_users ru ON ru.id = user_id
                    WHERE ru.id = %s
                    AND rc.name = ANY(%s)
                    ORDER BY rc.id
                """
                cr.execute(sql, (user.id, recent_company))
                recent_allowed_company = cr.dictfetchall()
            
            current_company_id = user.company_id.id
            current_company_name = user.company_id.name

            # user_companies = {'current_company': (user.company_id.id, user.company_id.name), 'allowed_companies': allowed_companies}
        else:
            current_company_id = False
            current_company_name = False
            recent_allowed_company = []
        
        # company_tree = request.env['res.users'].get_user_company_tree(user.id, type='management')
        # recent_company = request.env['jd.res.users.recent.company'].get_recent_companys(user.id)
        
        return {
            "session_id": request.session.sid,
            "uid": request.session.uid,
            "is_admin": request.env.user.has_group('base.group_system'),
            "is_superuser": request.env.user._is_superuser() if request.session.uid else False,
            "user_context": request.session.get_context() if request.session.uid else {},
            "db": request.session.db,
            "server_version": version_info.get('server_version'),
            "server_version_info": version_info.get('server_version_info'),
            "name": user.name,
            "username": user.login,
            "company_id": request.env.user.company_id.id if request.session.uid else None,
            "partner_id": request.env.user.partner_id.id if request.session.uid and request.env.user.partner_id else None,
            # "user_companies": user_companies,
            "currencies": self.get_currencies() if request.session.uid else {},
            # 增加用户的组织tree
            # 'company_tree': company_tree,
            # 'recent_company': recent_company,
            'display_switch_company_menu': display_switch_company_menu,
            'current_company_name': current_company_name,
            'current_company_id': current_company_id,
            'recent_allowed_company': recent_allowed_company
        }


    # def session_info(self):
    #     user = request.env.user
    #     display_switch_company_menu = user.has_group('base.group_multi_company') and len(user.company_ids) > 1
    #     version_info = odoo.service.common.exp_version()
    #     company_tree = request.env['res.users'].get_user_company_tree(user.id, type='management')
    #     recent_company = request.env['jd.res.users.recent.company'].get_recent_companys(user.id)
    #     return {
    #         "session_id": request.session.sid,
    #         "uid": request.session.uid,
    #         "is_system": user._is_system() if request.session.uid else False,
    #         "is_admin": user._is_admin() if request.session.uid else False,
    #         "user_context": request.session.get_context() if request.session.uid else {},
    #         "db": request.session.db,
    #         "server_version": version_info.get('server_version'),
    #         "server_version_info": version_info.get('server_version_info'),
    #         "name": user.name,
    #         "username": user.login,
    #         "partner_display_name": user.partner_id.display_name,
    #         "company_id": user.company_id.id if request.session.uid else None,
    #         "partner_id": user.partner_id.id if request.session.uid and user.partner_id else None,
    #         "user_companies": {'current_company': (user.company_id.id, user.company_id.name), 'allowed_companies': [(comp.id, comp.name) for comp in user.company_ids]} if display_switch_company_menu else False,
    #         "currencies": self.get_currencies() if request.session.uid else {},
    #         "web.base.url": self.env['ir.config_parameter'].sudo().get_param('web.base.url', default=''),
    #         "show_effect": True,
    #         # 增加用户的组织tree
    #         'company_tree': company_tree,
    #         'recent_company': recent_company
    #     }

