/**
 * Created by cx on 2018/7/12
 */

odoo.define('jd_digital_signature.signature_widget', function (require) {
    "use strict";

    var core = require('web.core');
    var Model = require('web.Model');
    var Dialog = require('web.Dialog');
    var FormView = require('web.FormView');
    var utils = require('web.utils');

    var _t = core._t;
    var QWeb = core.qweb;

    var FieldSignature = core.form_widget_registry.map.image.extend({
        template: 'SignatureWidget',
        // placeholder: "/web/static/src/img/placeholder.png",

        render_value: function () {
            this._super();

            var self = this,
                SignDialog = $(QWeb.render("SignatureDialog")),
                img_data;
            self.$el.find('.o_select_file_button').off().on('click', function () {
                self.$inputFile.click();
            });

            self.$el.find('.o_form_signature').removeClass('col-md-offset-5');

            self.$el.find('.o_form_signature').off().on('click', function () {
                new Dialog(self, {
                    size: 'large',
                    dialogClass: 'o_act_window',
                    title: _t("签名"),
                    $content: SignDialog,
                    buttons: [
                        {
                            text: _t("保存"), classes: 'btn-primary signature_save_btn', close: true,
                            click: function () {
                                var signature = $(".signature").jSignature("getData",'image');
                                var img_data_base64 = signature[1];
                                var approx_img_size = 3 * (img_data_base64.length / 4)
                                self.on_file_uploaded(approx_img_size, "signature-preview.jpeg", "image/jpeg", img_data_base64);
                            }
                        },
                        {
                            text: _t("关闭"), close: true
                        }
                    ]
                }).open();
                WidgetSign.initialize_content();
            });
        },
    });

    core.form_widget_registry.add('signature', FieldSignature);

    Dialog.include({
        destroy: function () {
            this._super.apply(this, arguments);
        },
    });

});
