(function (window) {
    var WidgetSign = {
        initialize_content: function () {
            var self = this;
            $('> img').remove();
            $('.signature > canvas').remove();
            var sign_options = {
                'decor-color': '#D1D0CE',
                'color': '#000',
                'background-color': '#fff',
                'height': '350',
                'width': '100%'
            };
            $(".signature").jSignature("init", sign_options);
            $(".signature").attr({"tabindex": "0", 'height': "280"});
            this.empty_sign = $(".signature").jSignature("getData", 'image');
            $('#sign_clean').click(this.on_clear_sign);
            $('.save_sign').click(this.on_save_sign);
        },
        on_clear_sign: function () {
            var self = this;
            $(".signature > canvas").remove();
            $('> img').remove();
            $(".signature").attr("tabindex", "0");
            var sign_options = {
                'decor-color': '#D1D0CE',
                'color': '#000',
                'background-color': '#fff',
                'height': '350',
                'width': '100%',
                'clear': true
            };
            $(".signature").jSignature(sign_options);
            $(".signature").focus();
            // self.set('value', false);
        },
        on_save_sign: function (value_) {
            var self = this;
            $('> img').remove();
            var signature = $(".signature").jSignature("getData", 'image');
            var is_empty = signature
                ? self.empty_sign[1] === signature[1]
                : false;
            if (!is_empty && typeof signature !== "undefined" && signature[1]) {
                console.log(signature[1])
                self.set('value', signature[1]);
            }
        }
    };

    WidgetSign.initialize_content();

    if (typeof define === 'function' && define.amd) {
        define(function () {
            return WidgetSign;
        });
    }
    else if (typeof module === 'object' && module.exports) {
        module.exports = WidgetSign;
    }
    else {
        window.WidgetSign = WidgetSign;
    }
}(window));

