# -*- encoding: utf-8 -*-
# 项目：JDG-
# 模块名称：
# 描述：
# Copyright 2018 JDG <www.yunside.com>
# Created by wxh (xianhuo.weng@yunside.com) at  2019/12/12 - 14:42

from odoo import fields, api, models
from odoo.exceptions import ValidationError


class AbstractBaseBiz(models.AbstractModel):
    _inherit = 'jdg.abstract.base.biz'

    ##############################################################
    ##########################电子签名相关##########################
    ##############################################################
    # TODO:将电子签名相关逻辑移动到电子签名模块继承实现
    @api.multi
    def get_signature_range(self):
        """
        默认单据范围是：集团内。
        可在具体单据重写
        :return: 
        """
        return 'inner'

    @api.multi
    def need_digital_signature(self):
        """
        单据是否需要电子签名
        :return: 
        """
        self.ensure_one()

        # 模块未安装则返回False
        # rec = self.env['ir.module.module'].sudo().search([('name', '=', 'jd_digital_signature')], limit=1)
        # if not rec or rec.state != 'installed':
        #     return False

        range_order = self.get_signature_range()
        config = self.env['jd.digital.signature.config'].sudo().search(
            [('model_id.model', '=', self._name), ('range', '=', range_order)])
        return config

    @api.multi
    def get_signature_order_info(self):
        """
        获得电子签名相关信息。如签名图片base64格式、签名人身份信息等
        可在具体单据重写
        :return: 
        """
        for item in self:
            # 获得该单据的所有签名
            result = {}
            result.update({
                'img_b64_info': self.env['jd.digital.signature.status'].get_signature_img_b64_info(item._name, item.id),
            })
            return result

    @api.multi
    def make_signature_signed(self):
        """
        审核检验 是否合成电子签名
        :return:
        """
        for item in self:
            res_model = item._name
            res_id = item.id
            # 判断当前单据签名图片是否上传完成
            is_finished, missing_info = \
                self.env['jd.digital.signature.status'].is_signature_upload_finish(res_model, res_id)
            if is_finished:
                self.env['jd.digital.signature.util'].create_signed_pdf(res_model, res_id)
            else:
                raise ValidationError(missing_info)

    @api.multi
    def discard_signature_signed(self):
        """
        反审核 删除签名图片 作废已完成签名的pdf
        :return:
        """
        for item in self:
            res_model = item._name
            res_id = item.id
            # 删除签名图片
            self.env['jd.digital.signature.status'].delete_signature(res_model, res_id)
            util = self.env['jd.digital.signature.util']
            signed_attachment = util.get_signed_attachment(res_model, res_id)
            if signed_attachment:
                discard_b64pdf = util.discard_pdf(signed_attachment.datas)

                # 覆盖签名单据
                signed_attachment.datas = discard_b64pdf
                filename = signed_attachment.name

                # 查看以往废弃数量
                recs = self.env['ir.attachment'].sudo().search(
                    [('res_model', '=', res_model), ('res_id', '=', res_id), ('name', 'ilike', '%_discard%pdf')])
                signed_attachment.name = filename.replace('_signed', '_discard%s' % len(recs) if recs else '_discard')

    @api.multi
    def get_auth_number_list(self):
        """
        获取该单据的鉴权信息
        返回联系方式的数组 签名配置按顺序取用
        :return:
        """
        pass
