# -*- coding: utf-8 -*-
from odoo import api, fields, models, tools


def get_parent_menu_id(item, data_ids, level=6):
    """ 返回所有父菜单 """
    data_ids.append(item.id)
    if level <= 0:
        return data_ids
    if item.parent_id:
        return get_parent_menu_id(item.parent_id, data_ids, level - 1)
    return data_ids


class IrUiMenu(models.Model):
    _inherit = 'ir.ui.menu'

    is_dashboard_menu = fields.Boolean(string=u'是否看板菜单')

    @api.model
    def search(self, args, offset=0, limit=None, order=None, count=False):
        menus = super(IrUiMenu, self).search(args, offset=0, limit=None, order=order, count=False)
        # if menus:
            # 添加筛选
            # print '1'
            # if self._context.get('jd.dashboard.menu'):
            #     ac = menus.filtered(lambda r: r.action and r.action.type == 'ir.actions.client' and r.action.tag == 'jd_dashboard.dashboardWidget')
            #     data_ids = []
            #     for item in ac:
            #         get_parent_menu_id(item, data_ids)
            #     menus = self.browse(data_ids)
        return len(menus) if count else menus

    @api.model
    def read_group(self, domain, fields, groupby, offset=0, limit=None, orderby=False, lazy=True):
        # # 添加筛选
        # if self._context.get('jd.dashboard.menu'):
        #     query = '''
        #       select id
        #       from ir_act_client
        #       where tag='jd_dashboard.dashboardWidget'
        #     '''
        #     self._cr.execute(query)
        #     fetched_data = self._cr.dictfetchall()
        #     data_ids = []
        #     base_ids = [r['id'] for r in fetched_data]
        #     print base_ids
        #     for item in base_ids:
        #         data_ids += self.search([('action', '=', 'ir.actions.client,%s' % item)]).ids
        #     data_domain = [('id', 'in', data_ids)]
        #     domain += data_domain
        # print '1'
        return super(IrUiMenu, self).read_group(domain, fields, groupby, offset, limit, orderby, lazy)

    @api.model
    def name_search(self, name='', args=None, operator='ilike', limit=100):
        # if self._context.get('jd.dashboard.menu'):
        #     # query = '''
        #     #   select id
        #     #   from ir_act_client
        #     #   where tag='jd_dashboard.dashboardWidget'
        #     # '''
        #     # self._cr.execute(query)
        #     # fetched_data = self._cr.dictfetchall()
        #     # data_ids = ['%s,%s' % ('ir.actions.client', r['id']) for r in fetched_data]
        #     # data_domain = ['action', 'in', data_ids]
        #     query = '''
        #                   select id
        #                   from ir_act_client
        #                   where tag='jd_dashboard.dashboardWidget'
        #                 '''
        #     self._cr.execute(query)
        #     fetched_data = self._cr.dictfetchall()
        #     data_ids = []
        #     base_ids = [r['id'] for r in fetched_data]
        #     print base_ids
        #     for item in base_ids:
        #         data_ids += self.search([('action', '=', 'ir.actions.client,%s' % item)]).ids
        #     data_domain = ['id', 'in', data_ids]
        #     args.append(data_domain)
        result = self._name_search(name, args, operator, limit=limit)
        return result