# -*- coding: utf-8 -*-
import logging
import time
from datetime import datetime
from odoo.tools.mail import html2plaintext
import json
from odoo import fields, models, api, exceptions
import pytz
from odoo import tools

_logger = logging.getLogger(__name__)


class DashboardData(models.Model):
    _name = 'jd.dashboard.widget.data'
    _description = u'KPI部件数据'
    
    name = fields.Char(string=u'名称', required=True)
    widget_id = fields.Many2one('jd.dashboard.widget', string=u'KPI部件', required=True)
    model = fields.Many2one('ir.model', string=u'模型', required=True, index=True)
    method = fields.Char(string=u'方法名', required=True)
    data_default = fields.Text(string=u'默认数据')
    param = fields.Char(string=u'参数')
    notes = fields.Text(string=u'描述')
    field_ids = fields.One2many('jd.dashboard.widget.data.field', 'widget_id', string=u'字段')

    # @api.model
    # def get_gauge_data(self):
    #     result = {'name': u'测试指标', 'value': 46, 'title': u'及格率', 'min': 10, 'max': 80}
    #     return result

    @api.model
    def get_gauge_data1(self):
        result = {'name': u'测试指标', 'value': 56, 'title': u'及格率', 'min': 50, 'max': 90}
        return result

    @api.model
    def get_gauge_data_bingzhuang(self):
        result = {'position': 'right', 'value1': 22, 'value2': 33, 'value3': 44, 'value4': 55, 'value5': 66}
        return result

    @api.model
    def get_data_list(self, params):
        '''
        获取KPI部件列表
        :param params:
        :return:
        '''
        widget_id = int(json.loads(params).get('widget_id', 0))
        dashboard_datas = self.search([])
        result = []
        for item in dashboard_datas:
            if item.widget_id.id == widget_id:
                result.append({
                    'id': item.id,
                    'name': item.name,
                    'model': item.model.model,
                    'method': item.method,
                    'param': eval(item.param) if item.param else '',
                    'data_default': item.data_default,
                    'notes': item.notes or '',
                })
            # print item.data_default
        return result
    
    @api.model
    def get_data_by_id(self, params):
        id = int(json.loads(params).get('id', 0))
        dashboard_data = self.browse(id)
        result = {
            'id': dashboard_data.id,
            'name': dashboard_data.name,
            'model': dashboard_data.model.model,
            'method': dashboard_data.method,
            'data_default': dashboard_data.data_default,
            'param': eval(dashboard_data.param) if dashboard_data.param else '',
            'notes': dashboard_data.notes or '',
        }
        return result


class DashboardDataField(models.Model):
    _name = 'jd.dashboard.widget.data.field'
    _description = u'首页KPI部件字段'
    widget_id = fields.Many2one('jd.dashboard.widget.data', string=u'KPI部件', index=True)
    field_id = fields.Many2one('ir.model.fields', string='字段', required=True)
    label = fields.Char(string=u'标题', required=True)

    @api.onchange("field_id")
    @api.multi
    def on_change_field_id(self):
        for item in self:
            if item.field_id.id:
                item.label = item.field_id.field_description
                item.name = item.field_id.name
            else:
                item.label = ''
                item.name = ''
