# -*- coding: utf-8 -*-
# Scorpio@JadeDragon Technology.
from odoo import models, fields, api, exceptions
import qrcode
import base64

class WizardEsignQrcode(models.TransientModel):
    """
        电子签名二维码
    """

    _name = 'jd.base.wizard.esign.qrcode'
    _description = u'电子签名二维码'
    _order = 'id asc'

    qr_code1 = fields.Binary('QRCode', readonly=True)
    qr_code2 = fields.Binary('QRCode', readonly=True)
    qr_code3 = fields.Binary('QRCode', readonly=True)
    qr_code4 = fields.Binary('QRCode', readonly=True)

    @api.model
    def default_get(self, fields):
        res = super(WizardEsignQrcode, self).default_get(fields)
        active_ids = self.env.context.get('active_ids')

        if self.env.context.get('active_model') == 'xxx' and active_ids:
            return res

        from io import BytesIO
        qr = qrcode.QRCode(
            version=1,
            error_correction=qrcode.constants.ERROR_CORRECT_H,
            box_size=5,
            border=1)
        url_string = 'https://xxxx.yunside.com/xlalbnkdkdkdlsls'
        qr.add_data(url_string)
        img = qr.make_image()
        byte_io = BytesIO()
        img.save(byte_io, 'PNG')
        byte_io.seek(0)
        base64_data = base64.b64encode(byte_io.getvalue())
        res.update({
            'qr_code1': base64_data,
            'qr_code2': base64_data,
            'qr_code3': base64_data,
            'qr_code4': base64_data,
        })
        return res
