odoo.define('jd_base.listView', function (require) {
    "use strict";
    var ListView = require('web.ListView');
    var core = require('web.core');
    var utils = require('web.utils');
    var QWeb = core.qweb;

    function synchronized(fn) {
        var fn_mutex = new utils.Mutex();
        return function () {
            var obj = this;
            var args = _.toArray(arguments);
            return fn_mutex.exec(function () {
                if (obj.isDestroyed()) { return $.when(); }
                return fn.apply(obj, args);
            });
        };
    }

    ListView.include({
        
        render_buttons: function ($node) {
            this._super($node);
            var self = this;
            if (self.$buttons) {
                var actionsString = self.fields_view.arch.attrs.actions;
                if (actionsString) {
                    actionsString = actionsString.replace(new RegExp(/'/g), '"');

                    var actionsList = null;
                    try {
                        actionsList = JSON.parse(actionsString);
                    } catch (e) {
                        console.error(e)
                        console.error(actionsString);
                    }
                    if (actionsList) {
                        for (var index in actionsList) {
                            var action = actionsList[index];
                            self.add_custom_action_button(action, index);
                        }
                    }
                }
            }
        },

        add_custom_action_button: function (options, index) {
            var self = this;
            var btnHtml = "<button type='button' class='btn btn-primary btn-sm custom-action-btn-" + index + "'>" + options.string + "</button>";
            $(btnHtml).appendTo(self.$buttons);

            self.$buttons.on('click', '.custom-action-btn-' + index, function () {
                self.do_action_button(options);
            });
        },

        /**
         * action 按钮事件
         * @param options
         */
        do_action_button: function (options) {
            var self = this;
            var ids = self.get_selected_ids();
            if (!ids) {
                ids = [];
            }
            self.do_execute_action(options, self.dataset, ids, null);
        },

        reload_content: synchronized(function() {
            // reload_content 清除所有checkbox
            // 增加 sidebar(打印、动作按钮)隐藏逻辑
            if (this.sidebar) {
                this.sidebar.do_hide();
            }
            var self = this;
            this.setup_columns(this.fields_view.fields, this.grouped);
            this.$('tbody .o_list_record_selector input').prop('checked', false);
            this.records.reset();
            var reloaded = $.Deferred();
            this.groups.render(function () {
                if (self.dataset.index === null) {
                    if (self.records.length) {
                        self.dataset.index = 0;
                    }
                } else if (self.dataset.index >= self.records.length) {
                    self.dataset.index = self.records.length ? 0 : null;
                }
                self.load_list().then(function () {
                    if (!self.grouped && self.display_nocontent_helper()) {
                        self.no_result();
                    }
                    reloaded.resolve();
                });
            });
            this.do_push_state({
                min: this.current_min,
                limit: this._limit
            });
            return reloaded.promise();
        }),
    }),

        ListView.List.include({
            render: function () {
                var self = this;
                this.$current.html(
                    QWeb.render('ListView.rows', _.extend({}, this, {
                        render_cell: function () {
                            return self.render_cell.apply(self, arguments);
                        }
                    })));
                var render_limit = this.view.fields_view.arch.attrs.render_limit || 4;
                this.pad_table_to(render_limit);
            }
        })
})