# -*- coding: utf-8 -*-
# Copyright 2018 JDG <www.yunside.com>
# Created by summerrain <summerrain5445@gmail.com> at 2018/8/1

from odoo import models, fields, api
import os
import base64


class MessageIo(models.Model):
    _name = 'jd.notify.channel.message.io'
    _description = u'推送消息流水'
    _order = 'id asc'

    channel = fields.Selection([('dingtalk', u'钉钉消息'),
                                ('sms', u'短信'),
                                ('wechat', u'微信'),
                                ('wechat_work', u'企业微信')], string=u'渠道', readonly=True)

    person = fields.Char(u'发送人', readonly=True)

    content = fields.Char(u'发送内容', readonly=True)

    state = fields.Selection([('success', u'成功'),
                              ('pending', u'发送中'),
                              ('failed', u'失败')], string=u'状态', readonly=True)

    note = fields.Char(string=u'备注')

    @api.model
    def insert_rec(self, channel, person, content, state, note=''):
        cr = self.env.cr
        cr.execute("""
            INSERT INTO jd_notify_channel_message_io(channel, person, content, state, note, create_date)
            VALUES (%s, %s, %s, %s, %s, CURRENT_TIMESTAMP AT TIME ZONE 'UTC')
        """, (channel, person, content, state, note))
