# -*- coding: utf-8 -*-
# Copyright 2018 JDG <www.yunside.com>
# Created by YGJ <guojian.ye@yunside.com> at 2018/9/6

from odoo import models, fields, api
from odoo.exceptions import ValidationError
from odoo.osv import expression


class JDGNotifyChannelMessage(models.AbstractModel):
    _name = 'jd.notify.channel.message'
    _inherit = ['mail.thread', 'ir.needaction_mixin']
    _description = u'玉龙科技系统内部消息发送通道'

    @api.model
    def post_message(self, body='', subject=None, **kwargs):
        """
        自定义消息推送接口。
        Created By YGJ @2018.09.05
        :param body: 消息内容。
        :param subject: 消息主题。
        :param message_type: email(向内部用户发送邮件)、notification(通知)、comment(备注)
        :param subtype: 消息子类型。
        :param parent_id: 父消息。
        :param attachments: 消息附件。
        :param content_subtype: html、plaintext
        :param kwargs: 扩展参数。
        :return:message
        """
        body = body
        subject = subject
        message_type = kwargs.get('message_type') if kwargs.get('message_type') else 'notification'
        if message_type != 'email':
            kwargs.update({
                'mail_server_id': None
            })
        subtype = kwargs.get('subtype') if kwargs.get('subtype') else None
        parent_id = kwargs.get('parent_id') if kwargs.get('parent_id') else None
        attachments = kwargs.get('attachments') if kwargs.get('attachments') else None
        content_subtype = kwargs.get('content_subtype') if kwargs.get('content_subtype') else 'plaintext'
        kwargs.update({
            'message_type': message_type,
            'subtype': subtype,
            'parent_id': parent_id,
            'attachments': attachments,
            'content_subtype': content_subtype
        })
        return self.message_post(body=body, subject=subject, **kwargs)

    @api.model
    def post_notification(self, body='', subject=None, **kwargs):
        """
        系统内部消息推送,向特定用户、关注的单据推送消息。
        Created By YGJ @2018.09.05
        :param body: 消息内容。
        :param subject: 消息主题，可选。
        :param kwargs: 扩展参数。
        :return: message
        """
        return self.message_post(subject=subject, body=body, message_type="notification", subtype="mt_comment",
                                 content_subtype='plaintext',
                                 **kwargs)
