# -*- encoding: utf-8 -*-
# 项目：JDG-
# Copyright 2018 JDG <www.yunside.com>
import logging
from odoo import api, models, fields

_logger = logging.getLogger(__name__)


class CreditDevice(models.Model):
    _name = 'jd.terminal.trusted.device'
    _inherit = 'jdg.abstract.base.data.m'
    _description = u'用户的授信设备'

    proxy_user_id = fields.Many2one('jd.proxy.user', u'代理用户')
    name = fields.Char(u'设备名称')
    device_id = fields.Char(u'设备id')
    note = fields.Char(u'备注')
    number = fields.Char(u'编码', readonly=True, default='/')

    @api.model
    def create(self, values):
        values.update({'number': self.env['ir.sequence'].next_by_code(self._name)})
        return super(CreditDevice, self).create(values)