# -*- encoding: utf-8 -*-
# 项目：JDG-
# Copyright 2018 JDG <www.yunside.com>
# Created by wxh (xianhuo.weng@yunside.com) at
from odoo import fields, api, models

import logging
_logger = logging.getLogger(__name__)


class WhiteList(models.Model):
    """
        白名单过滤。某个代理用户登录时，若该代理用户不存在于列表中，则需要进一步验证并在白名单插入记录才允许登录。
    """
    _name = 'jd.terminal.white.list'
    _inherit = 'jdg.abstract.base.data.m'
    _description = u'访问白名单'

    proxy_user_id = fields.Many2one('jd.proxy.user', u'代理用户', required=True)
    number = fields.Char(u'编码', readonly=True, default='/')

    @api.model
    def create(self, values):
        values.update({
            'number': self.env['ir.sequence'].sudo().next_by_code(self._name),
            'name': self.env['jd.proxy.user'].sudo().browse(values['proxy_user_id']).name
        })
        return super(WhiteList, self).create(values)
