# -*- coding: utf-8 -*-
# Scorpio@JadeDragon Technology.

from odoo import api, models, fields
from email.utils import formataddr


class MessageCategory(models.Model):
    _name = 'mail.message.category'

    parent_id = fields.Many2one('mail.message.category', u'上级分类')
    number = fields.Char(u'编码', readonly=True, default='/')
    name = fields.Char(u'名称', index=True, required=True)
    child_ids = fields.One2many('mail.message.category', 'parent_id', u'子分类')
    note = fields.Text(u'备注')

    @api.model
    def create(self, vals):
        if vals.get('number', '/') == '/':
            vals['number'] = self.env['ir.sequence'].sudo().next_by_code(self._name) or '/'
        return super(MessageCategory, self).create(vals)


class MailMessage(models.Model):
    _inherit = 'mail.message'
    categ_id = fields.Many2one('mail.message.category', u'分类')

    @api.model
    def _get_default_from(self):
        '''
        设置默认发件人邮箱地址
        :return:
        '''
        if self.env.user.email:
            return formataddr((self.env.user.name, self.env.user.email))
        return 'mail@yunside.com'
