# -*- coding: utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by HJH <jiahao.huang@yunside.com> at 2022/05/31

from odoo import models, fields, api, tools
import logging

_logger = logging.getLogger(__name__)


class StatJdSystemAnalysisBiz(models.Model):
    _name = 'stat.jd.system.analysis.biz'
    _description = u'用户访问行为多维分析'
    _auto = False
    _table = 'stat_jd_system_analysis_biz'
    _order = 'user_id'

    user_id = fields.Many2one('res.users', string=u'用户')
    model_id = fields.Many2one('ir.model', string=u'单据')
    times_access = fields.Integer(string=u'访问次数')
    times_create = fields.Integer(string=u'创建次数')
    times_write = fields.Integer(string=u'编辑次数')
    times_audit = fields.Integer(string=u'审核次数')
    times_unaudit = fields.Integer(string=u'反单次数')
    times_cancel = fields.Integer(string=u'作废次数')
    times_unlink = fields.Integer(string=u'删除次数')

    @api.model
    def read_group(self, domain, fields, groupby, offset=0, limit=None, orderby=False, lazy=True):
        return super(StatJdSystemAnalysisBiz, self.with_context(virtual_id=False)).read_group(domain, fields, groupby, offset=offset, limit=limit, lazy=lazy)

    @api.model_cr
    def init(self):
        tools.drop_view_if_exists(self._cr, 'stat_jd_system_analysis_biz')
        self.reset_view()

    @api.model_cr
    def reset_view(self):
        sql = '''
          CREATE OR REPLACE VIEW stat_jd_system_analysis_biz AS (
            SELECT
              row_number() OVER() AS id,
              log.user_id,
              log.model_id,
              log.times_access,
              log.times_create,
              log.times_write,
              log.times_audit,
              log.times_unaudit,
              log.times_cancel,
              log.times_unlink
            FROM jd_system_analysis_biz log
          );
        '''
        self._cr.execute(sql)
        