# -*- coding: utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by HJH <jiahao.huang@yunside.com> at 2022/05/25

from odoo import models, fields, api
import datetime
import logging

_logger = logging.getLogger(__name__)


class JdSystemAnalysisLogin(models.Model):
    _name = 'jd.system.analysis.login'
    _description = u'用户登录行为统计分析'

    user_id = fields.Many2one('res.users', string=u'操作用户')
    region = fields.Char(string=u'地区')
    hour_login = fields.Char(string=u'登录时段')
    times_login_success = fields.Integer(string=u'登录成功次数')
    times_login_fail = fields.Integer(string=u'登录失败次数')

    @api.model
    def add_login_times(self, user_id, country, city, result):
        cr = self.env.cr
        region = '%s%s' % (country or '', city or '') or '-'
        hour_login = '%s时' % (datetime.datetime.now() + datetime.timedelta(hours=8)).hour
        success = 1 if result == 'success' else 0
        fail = 1 if result == 'fail' else 0
        cr.callproc('JD_ADD_LOGIN_TIMES', [user_id, region, hour_login, success, fail])
        
