# -*- coding: utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by HJH <jiahao.huang@yunside.com> at 2022/05/31

from odoo import models, fields, api
import logging

_logger = logging.getLogger(__name__)


class JdSystemAnalysisBiz(models.Model):
    _name = 'jd.system.analysis.biz'
    _description = u'用户访问行为统计分析'

    user_id = fields.Many2one('res.users', string=u'用户')
    model_id = fields.Many2one('ir.model', string=u'单据')
    times_access = fields.Integer(string=u'访问次数')
    times_create = fields.Integer(string=u'创建次数')
    times_write = fields.Integer(string=u'编辑次数')
    times_audit = fields.Integer(string=u'审核次数')
    times_unaudit = fields.Integer(string=u'反单次数')
    times_cancel = fields.Integer(string=u'作废次数')
    times_unlink = fields.Integer(string=u'删除次数')

    @api.model
    def add_biz_times(self, user_id, model_id, action):
        cr = self.env.cr
        times_access = 1 if action == 'access' else 0
        times_create = 1 if action == 'create' else 0
        times_write = 1 if action == 'write' else 0
        times_audit = 1 if action == 'audit' else 0
        times_unaudit = 1 if action == 'unaudit' else 0
        times_cancel = 1 if action == 'cancel' else 0
        times_unlink = 1 if action == 'unlink' else 0
        cr.callproc('JD_ADD_BIZ_TIMES', [user_id, model_id, times_access, times_create, times_write, times_audit, times_unaudit, times_cancel, times_unlink])
        