# -*- coding:utf-8 -*-
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 2018/5/8
import logging
from odoo import models, fields

_logger = logging.getLogger(__name__)


class DownloadHistory(models.Model):
    _name = 'jd.download.history'
    _description = u"下发记录"

    model = fields.Char(u'模型', index=True)
    rec_id = fields.Integer(u'产品ID', index=True)
    rec_name = fields.Char(u'产品名称', index=True)
    status = fields.Selection([('0', u'正在下发'), ('1', u'成功'), ('2', u'失败')], string=u'状态')
    note = fields.Text(u'备注')
    data_node_id = fields.Many2one('jd.data.node', string=u'数据节点', index=True)
