# -*- coding:utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 2018/7/26
import logging
from odoo import models, fields

_logger = logging.getLogger(__name__)


class GroupsHistory(models.Model):
    _name = 'jd.groups.history'
    _description = u"权限变化记录"
    """
    用户权限变化的时候就添加一条记录
    """
    
    user_id = fields.Many2one('res.users', string=u'关联用户')
    src_id = fields.Char(string=u'来源单据')
    src_number = fields.Char(string=u'来源单据编码')
    operator_id = fields.Many2one('res.users', string=u'操作人')
    date = fields.Datetime(string=u'操作时间', default=fields.Datetime.now())
    note = fields.Text(string=u'备注')
    line_ids = fields.One2many('jd.groups.history.line', 'parent_id', string=u'权限变化记录明细')


class GroupsHistoryLine(models.Model):
    _name = 'jd.groups.history.line'
    _description = u"权限变化记录明细"
    """
    """

    parent_id = fields.Many2one('jd.groups.history', string=u'所属权限变化记录', ondelete='cascade')
    type = fields.Selection([('more', u'新增'),
                             ('less', u'减少')], string=u'变化类型')
    group_id = fields.Many2one('res.groups', string=u'权限组')
