# -*- coding: utf-8 -*-
# 项目: jdg-hd-node-farm
# Copyright 2018 JDG <www.yunside.com>
# Created by LLH <lianghua.liu@yunside.com> at 2018/7/1

from odoo import models, api, tools, fields

import time

from core.middleware.utils import today

import pytz

import logging

_logger = logging.getLogger(__name__)
tz_asia = pytz.timezone('Asia/Shanghai')


class DataExportStat(models.Model):
    _name = 'jd.base.data.export.stat'
    _description = u'数据导出多维分析'
    _auto = False
    _table = 'jd_base_data_export_stat'
    _order = 'id'

    company_id = fields.Many2one('res.company', string="组织")
    unit_id = fields.Many2one('res.company', string="五级单位")
    mgmt_id = fields.Many2one('res.company', string="四级公司")
    area_id = fields.Many2one('res.company', string="战区")
    user_id = fields.Many2one('res.users', string="用户")
    export_date = fields.Date(string="导出日期")
    menu_id = fields.Many2one('ir.ui.menu', string="菜单")
    export_id = fields.Many2one('ir.exports', string="模板")
    export_name = fields.Char(string="模板名")

    export_count = fields.Integer(string="导出次数")
    download_count = fields.Integer(string="下载次数")
    file_size = fields.Float(string="文件大小")
    export_minutes = fields.Float(string="导出时长")
    rows = fields.Integer(string="行数")
    columns = fields.Integer(string="列数")

    @api.model
    def read_group(self, domain, fields, groupby, offset=0, limit=None, orderby=False, lazy=True):
        # self.reset_view()
        return super(DataExportStat, self.with_context(virtual_id=False)).read_group(domain, fields,
                                                                                   groupby,
                                                                                   offset=offset,
                                                                                   limit=limit,
                                                                                   orderby=orderby,
                                                                                   lazy=lazy)


    @api.model_cr
    def init(self):
        tools.drop_view_if_exists(self._cr, 'jd_base_data_export_stat')
        self.reset_view()

    @api.model_cr
    def reset_view(self):
        sql = """
        CREATE OR REPLACE VIEW jd_base_data_export_stat AS (
            SELECT
                row_number() OVER ()    AS id,
                a.company_id            AS company_id,
                rc.id                   AS unit_id,
                rc1.id                  AS mgmt_id,
                rc2.id                  AS area_id,
                a.create_uid            AS user_id,
                a.export_start::date    AS export_date,
                a.menu_id               AS menu_id,
                a.export_id             AS export_id,
                mu.name || ' - ' || coalesce(ep.name, '未定义')      AS export_name,
                1::integer              AS export_count,
                a.download_count        AS download_count,
                a.file_size             AS file_size,
                a.export_minutes        AS export_minutes,
                a.rows,
                a.columns
            FROM jd_base_data_export_record a
            LEFT JOIN res_company rc ON rc.id = a.company_id AND rc.org_type IN ('svc','breeding','feed','hatch')
            LEFT JOIN res_company rc1 ON rc1.id = rc.management_parent_id AND rc1.org_type = 'management'
            LEFT JOIN res_Company rc2 ON rc2.id = rc1.management_parent_id AND rc2.org_type = 'area'
            LEFT JOIN ir_ui_menu mu ON mu.id = a.menu_id
            LEFT JOIN ir_exports ep ON ep.id = a.export_id
            ORDER BY a.id
        )
        """
        self._cr.execute(sql)
