# -*- coding:utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 2018/12/3
from odoo import api, models
from odoo.exceptions import ValidationError

class Base(models.AbstractModel):

    _inherit = 'base'

    @api.model
    def check_access_rights_button(self, operation, raise_exception=True):
        """
        验证当前用户是否有访问某些特殊按钮的权限
        """
        # 维护button的number和name的MAP
        # 传入number。 检查是否存在。不存在不应该调用这个方法。
        button_map = self.env['jd.button'].get_button_map()
        if operation in ('confirm', 'cancel'):
            return self.env['jd.button.access'].check(self._name, operation, raise_exception)
        else:
            if operation not in button_map.keys():
                raise ValidationError('不合法的输入类型，未找到类型为%s的按钮编码' % operation)
            else:
                return self.env['jd.button.access'].check(self._name, operation, raise_exception)
