# -*- coding:utf-8 -*-
# 项目: jdg-core-base
# Copyright 2018 JDG <www.yunside.com>
# Created by bjccdsrlcr (longjie.jiang@yunside.com) @ 2018/12/3

from odoo import models, fields, api
import logging

_logger = logging.getLogger(__name__)


class JdButton(models.Model):
    _name = 'jd.button'
    _description = u'按钮'
    """
    系统中全量的按钮
    """

    _sql_constraints = [
        ('number_uniq', 'unique (number)', u'编码重复！')
    ]

    number = fields.Char(string=u'编码', required=True)
    name = fields.Char(string=u'名称', required=True)
    note = fields.Text(string=u'备注')

    def get_button_map(self):
        """
        返回
        {'number': name}
        的所有按钮形式
        :return:
        """
        recs = self.env['jd.button'].sudo().search([])
        button_map = {}
        for rec in recs:
            button_map.update({
                rec.number: rec.name
            })
        # button_map = [{'number': rec.number, 'name': rec.name} for rec in recs]
        return button_map