# -*- encoding: utf-8 -*-
# 项目：JDG-
# 模块名称：消息抽象
# 描述：统一消息的接口方法
# Copyright 2018 JDG <www.yunside.com>
# Created by wxh (xianhuo.weng@yunside.com) at  2018/9/6 - 下午4:32
from odoo import models, api


class AbstractMessage(models.AbstractModel):
    _name = 'jdg.abstract.message'

    @api.model
    def make_message(self, subject, body, message_type, receiver, categ_id):
        '''
        产生消息
        :param categ_id: 消息分类
        :param subject: 消息主题
        :param body: 消息内容
        :param message_type: 消息类型（announce, tip, warning）
        :param receiver: [] res_partner_ids数组
        :return: 
        '''
        if not categ_id:
            categ_id = self.env.ref('jd_base.message_category_04').id

        subtype_id = self.env.ref('jd_base.message_subtype_tip').id
        if message_type == 'announce':
            subtype_id = self.env.ref('jd_base.message_subtype_announce').id
        elif message_type == 'tip':
            subtype_id = self.env.ref('jd_base.message_subtype_tip').id
        elif message_type == 'warning':
            subtype_id = self.env.ref('jd_base.message_subtype_warning').id
        return self.env['jd.notify.channel'].sudo().notify(channel_code='jd_message', receiver=receiver,
                                                    body=body,
                                                    subtype_id=subtype_id,
                                                    subject=subject,
                                                    categ_id=categ_id,
                                                    content_subtype='plaintext')
