# -*- coding: utf-8 -*-
# Copyright 2018 JDG <www.yunside.com>
# Create by Carmen <carmen.ling@yunside.com> at 2018/5/17

from odoo import models, fields, api
from odoo.exceptions import ValidationError
from odoo.osv import expression

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
#                               基类继承说明
#
#                              AbstractCore
#                                   |
#                              AbstractBase
#                             /            \
#                            /              \
#                           /                \
#                          /                  \
#                         /                    \
#               AbstractBaseData                AbstractBaseBiz
#               /            \                           |
#  AbstractBaseDataConfig   AbstractBaseDataMaster       |
#                                                        |
#                                               AbstractBaseBizFin
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #


class AbstractCore(models.AbstractModel):
    """
    核心基类，所有抽象基类均为它的子类
    """

    _name = 'jdg.abstract.core'
    _description = u"核心基类"

    data_node_id = fields.Integer(string=u'数据节点', default=lambda self:self.get_data_node_id())
    time_push = fields.Datetime(string=u'上拉时间', readonly=True)
    time_pull = fields.Datetime(string=u'下发时间', readonly=True)

    def do_push(self):
        """
        数据节点下发实现
        :return:
        """
        # something to do
        # then
        return self.jdg_sudo().write({
            'time_push': fields.Datetime.now()
        })

    def do_pull(self):
        """
        数据节点上拉实现
        :return:
        """
        # something to do
        # then
        return self.jdg_sudo().write({
            'time_pull': fields.Datetime.now()
        })
    
    def get_data_node_id(self):
        """
        获取数据节点id
        :return:
        """
        return self.env['ir.config_parameter'].sudo().get_param("jadedragon.microapp.data.node.id")